/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.multiblock;

import com.sammy.ortus.systems.multiblock.MultiBlockComponentEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockStructure {
    public final ArrayList<StructurePiece> structurePieces;

    public MultiBlockStructure(ArrayList<StructurePiece> structurePieces) {
        this.structurePieces = structurePieces;
    }

    public boolean canPlace(BlockPos core, Level level) {
        return this.structurePieces.stream().allMatch(p -> p.canPlace(core, level));
    }

    public void place(BlockPlaceContext context) {
        this.structurePieces.forEach(s -> s.place(context.m_8083_(), context.m_43725_()));
    }

    public static MultiBlockStructure of(StructurePiece ... pieces) {
        return new MultiBlockStructure(new ArrayList<StructurePiece>(List.of(pieces)));
    }

    public static class StructurePiece {
        public final Vec3i offset;
        public final BlockState state;

        public StructurePiece(int xOffset, int yOffset, int zOffset, BlockState state) {
            this.offset = new Vec3i(xOffset, yOffset, zOffset);
            this.state = state;
        }

        public boolean canPlace(BlockPos core, Level level) {
            BlockPos pos = core.m_141952_(this.offset);
            BlockState existingState = level.m_8055_(pos);
            return existingState.m_60767_().m_76336_();
        }

        public void place(BlockPos core, Level level) {
            this.place(core, level, this.state);
        }

        public void place(BlockPos core, Level level, BlockState state) {
            BlockPos pos = core.m_141952_(this.offset);
            level.m_7731_(pos, state, 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MultiBlockComponentEntity) {
                MultiBlockComponentEntity component = (MultiBlockComponentEntity)blockEntity;
                component.corePos = core;
            }
        }
    }
}

