/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.fireeffect;

import com.sammy.ortus.setup.OrtusFireEffects;
import com.sammy.ortus.systems.fireeffect.FireEffectType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;

public class FireEffectInstance {
    public int duration;
    public final FireEffectType type;

    public FireEffectInstance(FireEffectType type) {
        this.type = type;
    }

    public FireEffectInstance extendDuration(int increase) {
        this.duration += increase;
        return this;
    }

    public FireEffectInstance setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public void tick(Entity target) {
        if (target.f_146808_ || target.m_20071_()) {
            this.type.extinguish(this, target);
        }
        if (target.m_5825_()) {
            this.duration -= 4;
        } else {
            --this.duration;
            if (this.type.isValid(this) && this.duration % this.type.getTickInterval(this) == 0) {
                this.type.tick(this, target);
            }
        }
    }

    public boolean isValid() {
        return this.type.isValid(this);
    }

    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128359_("type", this.type.id);
        tag.m_128405_("duration", this.duration);
        return tag;
    }

    public static FireEffectInstance deserializeNBT(CompoundTag tag) {
        FireEffectInstance instance = new FireEffectInstance(OrtusFireEffects.FIRE_TYPES.get(tag.m_128461_("type")));
        instance.setDuration(tag.m_128451_("duration"));
        return instance;
    }
}

