/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.blockentity;

import com.sammy.ortus.helpers.DataHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class OrtusBlockEntityInventory
extends ItemStackHandler {
    public final int slotCount;
    public final int slotSize;
    public Predicate<ItemStack> inputPredicate;
    public Predicate<ItemStack> outputPredicate;
    public final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this);
    public ArrayList<Item> items = new ArrayList();
    public ArrayList<ItemStack> nonEmptyStacks = new ArrayList();
    public int emptyItemAmount;
    public int nonEmptyItemAmount;
    public int firstEmptyItemIndex;

    public OrtusBlockEntityInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate, Predicate<ItemStack> outputPredicate) {
        this(slotCount, slotSize, inputPredicate);
        this.outputPredicate = outputPredicate;
    }

    public OrtusBlockEntityInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate) {
        this(slotCount, slotSize);
        this.inputPredicate = inputPredicate;
    }

    public OrtusBlockEntityInventory(int slotCount, int slotSize) {
        super(slotCount);
        this.slotCount = slotCount;
        this.slotSize = slotSize;
        this.updateData();
    }

    public void onContentsChanged(int slot) {
        this.updateData();
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotSize;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.inputPredicate != null && !this.inputPredicate.test(stack)) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputPredicate != null && !this.outputPredicate.test(super.extractItem(slot, amount, true))) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void updateData() {
        this.items = this.getItems();
        this.nonEmptyStacks = this.getNonEmptyItemStacks();
        this.emptyItemAmount = this.getEmptyItemCount();
        this.nonEmptyItemAmount = this.getNonEmptyItemCount();
        this.firstEmptyItemIndex = this.getFirstEmptyItemIndex();
    }

    public void load(CompoundTag compound) {
        this.load(compound, "inventory");
    }

    public void load(CompoundTag compound, String name) {
        this.deserializeNBT(compound.m_128469_(name));
        if (this.stacks.size() != this.slotCount) {
            int missing = this.slotCount - this.stacks.size();
            for (int i = 0; i < missing; ++i) {
                this.stacks.add((Object)ItemStack.f_41583_);
            }
        }
        this.updateData();
    }

    public void save(CompoundTag compound) {
        this.save(compound, "inventory");
    }

    public void save(CompoundTag compound, String name) {
        compound.m_128365_(name, (Tag)this.serializeNBT());
    }

    public int getFirstEmptyItemIndex() {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public boolean isEmpty() {
        return this.nonEmptyItemAmount == 0;
    }

    protected int getNonEmptyItemCount() {
        return (int)this.getStacks().stream().filter(s -> !s.m_41619_()).count();
    }

    protected int getEmptyItemCount() {
        return (int)this.getStacks().stream().filter(ItemStack::m_41619_).count();
    }

    protected ArrayList<ItemStack> getNonEmptyItemStacks() {
        return this.getStacks().stream().filter(s -> !s.m_41619_()).collect(Collectors.toCollection(ArrayList::new));
    }

    protected ArrayList<Item> getItems() {
        return this.getStacks().stream().map(ItemStack::m_41720_).collect(Collectors.toCollection(ArrayList::new));
    }

    protected ArrayList<Item> getNonEmptyItems() {
        return this.getNonEmptyItemStacks().stream().map(ItemStack::m_41720_).collect(Collectors.toCollection(ArrayList::new));
    }

    public void clear() {
        for (int i = 0; i < this.slotCount; ++i) {
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void dumpItems(Level level, BlockPos pos) {
        this.dumpItems(level, DataHelper.fromBlockPos(pos).m_82520_(0.5, 0.5, 0.5));
    }

    public void dumpItems(Level level, Vec3 pos) {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).m_41619_()) {
                level.m_7967_((Entity)new ItemEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), this.getStackInSlot(i)));
            }
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public ItemStack interact(Level level, Player player, InteractionHand handIn) {
        ItemStack held = player.m_21120_(handIn);
        player.m_21011_(handIn, true);
        int size = this.nonEmptyStacks.size() - 1;
        if ((held.m_41619_() || this.firstEmptyItemIndex == -1) && size != -1) {
            boolean success;
            ItemStack takeOutStack = this.nonEmptyStacks.get(size);
            if (takeOutStack.m_41720_().equals(held.m_41720_())) {
                return this.insertItem(level, held);
            }
            ItemStack extractedStack = this.extractItem(level, held, player);
            boolean bl = success = !extractedStack.m_41619_();
            if (success) {
                this.insertItem(level, held);
            }
            return extractedStack;
        }
        return this.insertItem(level, held);
    }

    public ItemStack extractItem(Level level, ItemStack heldStack, Player player) {
        if (!level.f_46443_) {
            ArrayList<ItemStack> nonEmptyStacks = this.nonEmptyStacks;
            if (nonEmptyStacks.isEmpty()) {
                return heldStack;
            }
            ItemStack takeOutStack = (ItemStack)nonEmptyStacks.get(nonEmptyStacks.size() - 1);
            int slot = this.stacks.indexOf((Object)takeOutStack);
            if (this.extractItem(slot, takeOutStack.m_41613_(), true).equals(ItemStack.f_41583_)) {
                return heldStack;
            }
            this.extractItem(player, takeOutStack, slot);
            return takeOutStack;
        }
        return ItemStack.f_41583_;
    }

    public void extractItem(Player playerEntity, ItemStack stack, int slot) {
        ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)stack, (int)playerEntity.m_150109_().f_35977_);
        this.setStackInSlot(slot, ItemStack.f_41583_);
    }

    public ItemStack insertItem(Level level, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_()) {
            ItemStack simulate = this.insertItem(stack, true);
            if (simulate.equals(stack)) {
                return ItemStack.f_41583_;
            }
            int count = stack.m_41613_() - simulate.m_41613_();
            if (count > this.slotSize) {
                count = this.slotSize;
            }
            ItemStack input = stack.m_41620_(count);
            this.insertItem(input, false);
            return input;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack, (boolean)simulate);
    }
}

