/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.block;

import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.block.OrtusThrowawayBlockData;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class OrtusBlockProperties
extends BlockBehaviour.Properties {
    public OrtusBlockProperties(Material material, MaterialColor color) {
        super(material, state -> color);
    }

    public OrtusBlockProperties(Material material) {
        super(material, state -> material.m_76339_());
    }

    public static void setRenderLayers(FMLClientSetupEvent event) {
        DataHelper.getAll(new ArrayList(ForgeRegistries.BLOCKS.getValues()), b -> b.f_60439_ instanceof OrtusBlockProperties && ((OrtusBlockProperties)b.f_60439_).getThrowawayData().isCutoutLayer).forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)RenderType.m_110457_()));
    }

    public OrtusBlockProperties addThrowawayData(Function<OrtusThrowawayBlockData, OrtusThrowawayBlockData> function) {
        OrtusThrowawayBlockData.DATA_CACHE.put(this, function.apply(OrtusThrowawayBlockData.DATA_CACHE.getOrDefault((Object)this, new OrtusThrowawayBlockData())));
        return this;
    }

    public OrtusThrowawayBlockData getThrowawayData() {
        return OrtusThrowawayBlockData.DATA_CACHE.getOrDefault((Object)this, new OrtusThrowawayBlockData());
    }

    public OrtusBlockProperties needsPickaxe() {
        this.addThrowawayData(d -> d.needsPickaxe());
        return this;
    }

    public OrtusBlockProperties needsAxe() {
        this.addThrowawayData(d -> d.needsAxe());
        return this;
    }

    public OrtusBlockProperties needsShovel() {
        this.addThrowawayData(d -> d.needsShovel());
        return this;
    }

    public OrtusBlockProperties needsHoe() {
        this.addThrowawayData(d -> d.needsHoe());
        return this;
    }

    public OrtusBlockProperties needsStone() {
        this.addThrowawayData(d -> d.needsStone());
        return this;
    }

    public OrtusBlockProperties needsIron() {
        this.addThrowawayData(d -> d.needsIron());
        return this;
    }

    public OrtusBlockProperties needsDiamond() {
        this.addThrowawayData(d -> d.needsDiamond());
        return this;
    }

    public OrtusBlockProperties isCutoutLayer() {
        this.addThrowawayData(d -> d.isCutoutLayer());
        return this;
    }

    public OrtusBlockProperties hasCustomLoot() {
        this.addThrowawayData(d -> d.hasCustomLoot());
        return this;
    }

    public OrtusBlockProperties noCollission() {
        return (OrtusBlockProperties)super.m_60910_();
    }

    public OrtusBlockProperties noOcclusion() {
        return (OrtusBlockProperties)super.m_60955_();
    }

    public OrtusBlockProperties friction(float p_60912_) {
        return (OrtusBlockProperties)super.m_60911_(p_60912_);
    }

    public OrtusBlockProperties speedFactor(float p_60957_) {
        return (OrtusBlockProperties)super.m_60956_(p_60957_);
    }

    public OrtusBlockProperties jumpFactor(float p_60968_) {
        return (OrtusBlockProperties)super.m_60967_(p_60968_);
    }

    public OrtusBlockProperties sound(SoundType p_60919_) {
        return (OrtusBlockProperties)super.m_60918_(p_60919_);
    }

    public OrtusBlockProperties lightLevel(ToIntFunction<BlockState> p_60954_) {
        return (OrtusBlockProperties)super.m_60953_(p_60954_);
    }

    public OrtusBlockProperties strength(float p_60914_, float p_60915_) {
        return (OrtusBlockProperties)super.m_60913_(p_60914_, p_60915_);
    }

    public OrtusBlockProperties instabreak() {
        return (OrtusBlockProperties)super.m_60966_();
    }

    public OrtusBlockProperties strength(float p_60979_) {
        return (OrtusBlockProperties)super.m_60978_(p_60979_);
    }

    public OrtusBlockProperties randomTicks() {
        return (OrtusBlockProperties)super.m_60977_();
    }

    public OrtusBlockProperties dynamicShape() {
        return (OrtusBlockProperties)super.m_60988_();
    }

    public OrtusBlockProperties noDrops() {
        return (OrtusBlockProperties)super.m_60993_();
    }

    public OrtusBlockProperties dropsLike(Block p_60917_) {
        return (OrtusBlockProperties)super.m_60916_(p_60917_);
    }

    public OrtusBlockProperties lootFrom(Supplier<? extends Block> blockIn) {
        this.hasCustomLoot();
        return (OrtusBlockProperties)super.lootFrom(blockIn);
    }

    public OrtusBlockProperties air() {
        return (OrtusBlockProperties)super.m_60996_();
    }

    public OrtusBlockProperties isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> p_60923_) {
        return (OrtusBlockProperties)super.m_60922_(p_60923_);
    }

    public OrtusBlockProperties isRedstoneConductor(BlockBehaviour.StatePredicate p_60925_) {
        return (OrtusBlockProperties)super.m_60924_(p_60925_);
    }

    public OrtusBlockProperties isSuffocating(BlockBehaviour.StatePredicate p_60961_) {
        return (OrtusBlockProperties)super.m_60960_(p_60961_);
    }

    public OrtusBlockProperties isViewBlocking(BlockBehaviour.StatePredicate p_60972_) {
        return (OrtusBlockProperties)super.m_60971_(p_60972_);
    }

    public OrtusBlockProperties hasPostProcess(BlockBehaviour.StatePredicate p_60983_) {
        return (OrtusBlockProperties)super.m_60982_(p_60983_);
    }

    public OrtusBlockProperties emissiveRendering(BlockBehaviour.StatePredicate p_60992_) {
        return (OrtusBlockProperties)super.m_60991_(p_60992_);
    }

    public OrtusBlockProperties requiresCorrectToolForDrops() {
        return (OrtusBlockProperties)super.m_60999_();
    }

    public OrtusBlockProperties color(MaterialColor p_155950_) {
        return (OrtusBlockProperties)super.m_155949_(p_155950_);
    }

    public OrtusBlockProperties destroyTime(float p_155955_) {
        return (OrtusBlockProperties)super.m_155954_(p_155955_);
    }

    public OrtusBlockProperties explosionResistance(float p_155957_) {
        return (OrtusBlockProperties)super.m_155956_(p_155957_);
    }
}

