/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.setup;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.sammy.ortus.handlers.RenderHandler;
import com.sammy.ortus.setup.OrtusShaders;
import com.sammy.ortus.systems.rendering.ShaderUniformHandler;
import com.sammy.ortus.systems.rendering.StateShards;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;

public class OrtusRenderTypes
extends RenderStateShard {
    public static final HashMap<Pair<Integer, RenderType>, RenderType> COPIES = new HashMap();
    public static final RenderType ADDITIVE_PARTICLE = OrtusRenderTypes.createGenericRenderType("ortus", "additive_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, OrtusShaders.ADDITIVE_PARTICLE.shard, StateShards.ADDITIVE_TRANSPARENCY, TextureAtlas.f_118260_);
    public static final RenderType ADDITIVE_BLOCK_PARTICLE = OrtusRenderTypes.createGenericRenderType("ortus", "additive_block_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, OrtusShaders.ADDITIVE_PARTICLE.shard, StateShards.ADDITIVE_TRANSPARENCY, TextureAtlas.f_118259_);
    public static final RenderType ADDITIVE_BLOCK = OrtusRenderTypes.createGenericRenderType("ortus", "block", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.ADDITIVE_TEXTURE.shard, StateShards.ADDITIVE_TRANSPARENCY, TextureAtlas.f_118259_);
    public static final Function<ResourceLocation, RenderType> SOLID_TEXTURE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "solid_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, RenderStateShard.f_173103_, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> ADDITIVE_TEXTURE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "additive_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.ADDITIVE_TEXTURE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> RADIAL_NOISE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "radial_noise", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.RADIAL_NOISE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> RADIAL_SCATTER_NOISE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "radial_scatter_noise", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.RADIAL_SCATTER_NOISE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> SCROLLING_TEXTURE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "scrolling_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.SCROLLING_TEXTURE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> TEXTURE_TRIANGLE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "texture_triangle", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.TRIANGLE_TEXTURE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<ResourceLocation, RenderType> SCROLLING_TEXTURE_TRIANGLE = texture -> OrtusRenderTypes.createGenericRenderType("ortus", "scrolling_texture_triangle", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, OrtusShaders.SCROLLING_TRIANGLE_TEXTURE.shard, StateShards.ADDITIVE_TRANSPARENCY, texture);
    public static final Function<RenderTypeData, RenderType> GENERIC = data -> OrtusRenderTypes.createGenericRenderType(data.name, data.format, data.mode, data.shader, data.transparency, data.texture);

    public OrtusRenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static RenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        return OrtusRenderTypes.createGenericRenderType(name.substring(0, name.indexOf(":")), name.substring(name.indexOf(":") + 1), format, mode, shader, transparency, texture);
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        RenderType.CompositeRenderType type = RenderType.m_173215_((String)(modId + ":" + name), (VertexFormat)format, (VertexFormat.Mode)mode, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(shader).m_110687_(new RenderStateShard.WriteMaskStateShard(true, true)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(transparency).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110661_(new RenderStateShard.CullStateShard(true)).m_110691_(true));
        RenderHandler.BUFFERS.put((RenderType)type, new BufferBuilder(type.m_110507_()));
        return type;
    }

    public static RenderType queueUniformChanges(RenderType type, ShaderUniformHandler handler) {
        RenderHandler.HANDLERS.put(type, handler);
        return type;
    }

    public static RenderType copy(int index, RenderType type) {
        return COPIES.computeIfAbsent((Pair<Integer, RenderType>)Pair.of((Object)index, (Object)type), p -> GENERIC.apply(new RenderTypeData((RenderType.CompositeRenderType)type)));
    }

    public static class RenderTypeData {
        public final String name;
        public final VertexFormat format;
        public final VertexFormat.Mode mode;
        public final RenderStateShard.ShaderStateShard shader;
        public RenderStateShard.TransparencyStateShard transparency = StateShards.ADDITIVE_TRANSPARENCY;
        public final ResourceLocation texture;

        public RenderTypeData(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, ResourceLocation texture) {
            this.name = name;
            this.format = format;
            this.mode = mode;
            this.shader = shader;
            this.texture = texture;
        }

        public RenderTypeData(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
            this(name, format, mode, shader, texture);
            this.transparency = transparency;
        }

        public RenderTypeData(RenderType.CompositeRenderType type) {
            this(type.f_110133_, type.m_110508_(), type.m_173186_(), type.f_110511_.f_173274_, type.f_110511_.f_110577_, (ResourceLocation)type.f_110511_.f_110576_.m_142706_().get());
        }
    }
}

