/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.setup;

import com.sammy.ortus.block.sign.OrtusStandingSignBlock;
import com.sammy.ortus.block.sign.OrtusWallSignBlock;
import com.sammy.ortus.blockentity.OrtusSignBlockEntity;
import com.sammy.ortus.systems.multiblock.IOrtusMultiblockComponent;
import com.sammy.ortus.systems.multiblock.MultiBlockComponentEntity;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OrtusBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"ortus");
    public static final RegistryObject<BlockEntityType<MultiBlockComponentEntity>> MULTIBLOCK_COMPONENT = BLOCK_ENTITY_TYPES.register("multiblock_component", () -> BlockEntityType.Builder.m_155273_(MultiBlockComponentEntity::new, (Block[])OrtusBlockEntities.getBlocks(IOrtusMultiblockComponent.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<OrtusSignBlockEntity>> SIGN = BLOCK_ENTITY_TYPES.register("sign", () -> BlockEntityType.Builder.m_155273_(OrtusSignBlockEntity::new, (Block[])OrtusBlockEntities.getBlocks(OrtusStandingSignBlock.class, OrtusWallSignBlock.class)).m_58966_(null));

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(block))) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!clazz.equals(block.getClass())) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    @Mod.EventBusSubscriber(modid="ortus", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientOnly {
        @SubscribeEvent
        public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)SIGN.get(), SignRenderer::new);
        }
    }
}

