/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.network.screenshake;

import com.sammy.ortus.handlers.ScreenshakeHandler;
import com.sammy.ortus.systems.screenshake.PositionedScreenshakeInstance;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class PositionedScreenshakePacket {
    Vec3 position;
    public float falloffDistance;
    public float maxDistance;
    float intensity;
    float falloffTransformSpeed;
    int timeBeforeFastFalloff;
    float slowFalloff;
    float fastFalloff;

    public PositionedScreenshakePacket(Vec3 position, float falloffDistance, float maxDistance, float intensity, float falloffTransformSpeed, int timeBeforeFastFalloff, float slowFalloff, float fastFalloff) {
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.intensity = intensity;
        this.falloffTransformSpeed = falloffTransformSpeed;
        this.timeBeforeFastFalloff = timeBeforeFastFalloff;
        this.slowFalloff = slowFalloff;
        this.fastFalloff = fastFalloff;
    }

    public static PositionedScreenshakePacket decode(FriendlyByteBuf buf) {
        return new PositionedScreenshakePacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.position.f_82479_);
        buf.writeDouble(this.position.f_82480_);
        buf.writeDouble(this.position.f_82481_);
        buf.writeFloat(this.falloffDistance);
        buf.writeFloat(this.maxDistance);
        buf.writeFloat(this.intensity);
        buf.writeFloat(this.falloffTransformSpeed);
        buf.writeInt(this.timeBeforeFastFalloff);
        buf.writeFloat(this.slowFalloff);
        buf.writeFloat(this.fastFalloff);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ScreenshakeHandler.addScreenshake(new PositionedScreenshakeInstance(this.position, this.falloffDistance, this.maxDistance, this.intensity, this.falloffTransformSpeed, this.timeBeforeFastFalloff, this.slowFalloff, this.fastFalloff)));
        context.get().setPacketHandled(true);
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, PositionedScreenshakePacket.class, PositionedScreenshakePacket::encode, PositionedScreenshakePacket::decode, PositionedScreenshakePacket::execute);
    }
}

