/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class TotemOfUndyingEffectPacket {
    private final int entityId;
    private final ItemStack stack;

    public TotemOfUndyingEffectPacket(Entity entity, ItemStack stack) {
        this.entityId = entity.m_142049_();
        this.stack = stack;
    }

    public TotemOfUndyingEffectPacket(int entityId, ItemStack stack) {
        this.entityId = entityId;
        this.stack = stack;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, TotemOfUndyingEffectPacket.class, TotemOfUndyingEffectPacket::encode, TotemOfUndyingEffectPacket::decode, TotemOfUndyingEffectPacket::execute);
    }

    public static TotemOfUndyingEffectPacket decode(FriendlyByteBuf buf) {
        return new TotemOfUndyingEffectPacket(buf.readInt(), buf.m_130267_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130055_(this.stack);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.triggerTotem(this.entityId, this.stack);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void triggerTotem(int entityId, ItemStack stack) {
            Minecraft minecraft = Minecraft.m_91087_();
            Entity entity = minecraft.f_91073_.m_6815_(entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                minecraft.f_91061_.m_107332_((Entity)livingEntity, (ParticleOptions)ParticleTypes.f_123767_, 30);
                minecraft.f_91073_.m_7785_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12513_, livingEntity.m_5720_(), 1.0f, 1.0f, false);
                if (livingEntity == minecraft.f_91074_) {
                    minecraft.f_91063_.m_109113_(stack);
                }
            }
        }
    }
}

