/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.network;

import com.sammy.ortus.handlers.WorldEventHandler;
import com.sammy.ortus.setup.worldevent.OrtusWorldEventTypes;
import com.sammy.ortus.systems.worldevent.WorldEventInstance;
import com.sammy.ortus.systems.worldevent.WorldEventType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SyncWorldEventPacket {
    String type;
    public boolean start;
    public CompoundTag eventData;

    public SyncWorldEventPacket(String type, boolean start, CompoundTag eventData) {
        this.type = type;
        this.start = start;
        this.eventData = eventData;
    }

    public static SyncWorldEventPacket decode(FriendlyByteBuf buf) {
        return new SyncWorldEventPacket(buf.m_130277_(), buf.readBoolean(), buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.type);
        buf.writeBoolean(this.start);
        buf.m_130079_(this.eventData);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.addWorldEvent(this.type, this.start, this.eventData);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncWorldEventPacket.class, SyncWorldEventPacket::encode, SyncWorldEventPacket::decode, SyncWorldEventPacket::execute);
    }

    public static class ClientOnly {
        public static void addWorldEvent(String type, boolean start, CompoundTag eventData) {
            WorldEventType eventType = OrtusWorldEventTypes.EVENT_TYPES.get(type);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            WorldEventInstance instance = WorldEventHandler.addWorldEvent((Level)level, eventType.createInstance(eventData));
            if (start) {
                instance.start((Level)level);
            }
        }
    }
}

