/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.network;

import com.sammy.ortus.capability.PlayerDataCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SyncPlayerCapabilityDataServerPacket {
    private final UUID uuid;
    private final CompoundTag tag;

    public SyncPlayerCapabilityDataServerPacket(UUID uuid, CompoundTag tag) {
        this.uuid = uuid;
        this.tag = tag;
    }

    public static SyncPlayerCapabilityDataServerPacket decode(FriendlyByteBuf buf) {
        return new SyncPlayerCapabilityDataServerPacket(buf.m_130259_(), buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130079_(this.tag);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Player player = ((NetworkEvent.Context)context.get()).getSender().f_19853_.m_46003_(this.uuid);
            if (player != null) {
                PlayerDataCapability.getCapability(player).ifPresent(c -> c.deserializeNBT(this.tag));
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncPlayerCapabilityDataServerPacket.class, SyncPlayerCapabilityDataServerPacket::encode, SyncPlayerCapabilityDataServerPacket::decode, SyncPlayerCapabilityDataServerPacket::execute);
    }
}

