/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.rendering.ShaderHolder;
import com.sammy.ortus.systems.rendering.TrailPoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RenderHelper {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static ShaderInstance getShader(RenderType type) {
        if (type instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
            Optional shader = compositeRenderType.f_110511_.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float u, float v, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, u / xCanvasSize, v / yCanvasSize, (float)width / xCanvasSize, (float)height / yCanvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, u / xCanvasSize, v / yCanvasSize, uWidth / xCanvasSize, vHeight / yCanvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float u, float v, float canvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, u / canvasSize, v / canvasSize, (float)((double)x + width) / canvasSize, (float)((double)y + height) / canvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight, float canvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, u / canvasSize, v / canvasSize, uWidth / canvasSize, vHeight / canvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, r, g, b, a, u / xCanvasSize, v / yCanvasSize, (float)width / xCanvasSize, (float)height / yCanvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, r, g, b, a, u / xCanvasSize, v / yCanvasSize, uWidth / xCanvasSize, vHeight / yCanvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float canvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, r, g, b, a, u / canvasSize, v / canvasSize, (float)width / canvasSize, (float)height / canvasSize);
    }

    public static void blit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight, float canvasSize) {
        RenderHelper.innerBlit(stack, shader, x, y, width, height, r, g, b, a, u / canvasSize, v / canvasSize, uWidth / canvasSize, vHeight / canvasSize);
    }

    public static void innerBlit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight) {
        Matrix4f last = stack.m_85850_().m_85861_();
        RenderSystem.m_157427_(shader.getInstance());
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(last, (float)x, (float)y + (float)height, 0.0f).m_85950_(r, g, b, a).m_7421_(u, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y + (float)height, 0.0f).m_85950_(r, g, b, a).m_7421_(u + uWidth, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(u + uWidth, v).m_5752_();
        bufferbuilder.m_85982_(last, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void innerBlit(PoseStack stack, ShaderHolder shader, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight) {
        Matrix4f last = stack.m_85850_().m_85861_();
        RenderSystem.m_157427_(shader.getInstance());
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(last, (float)x, (float)y + (float)height, 0.0f).m_7421_(u, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y + (float)height, 0.0f).m_7421_(u + uWidth, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y, 0.0f).m_7421_(u + uWidth, v).m_5752_();
        bufferbuilder.m_85982_(last, (float)x, (float)y, 0.0f).m_7421_(u, v).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float u, float v, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, u / xCanvasSize, v / yCanvasSize, (float)width / xCanvasSize, (float)height / yCanvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, u / xCanvasSize, v / yCanvasSize, uWidth / xCanvasSize, vHeight / yCanvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float u, float v, float canvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, u / canvasSize, v / canvasSize, (float)width / canvasSize, (float)height / canvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight, float canvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, u / canvasSize, v / canvasSize, uWidth / canvasSize, vHeight / canvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, r, g, b, a, u / xCanvasSize, v / yCanvasSize, (float)width / xCanvasSize, (float)height / yCanvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight, float xCanvasSize, float yCanvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, r, g, b, a, u / xCanvasSize, v / yCanvasSize, uWidth / xCanvasSize, vHeight / yCanvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float canvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, r, g, b, a, u / canvasSize, v / canvasSize, (float)width / canvasSize, (float)height / canvasSize);
    }

    public static void blit(PoseStack stack, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight, float canvasSize) {
        RenderHelper.innerBlit(stack, x, y, width, height, r, g, b, a, u / canvasSize, v / canvasSize, uWidth / canvasSize, vHeight / canvasSize);
    }

    public static void innerBlit(PoseStack stack, int x, int y, double width, double height, float r, float g, float b, float a, float u, float v, float uWidth, float vHeight) {
        Matrix4f last = stack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(last, (float)x, (float)y + (float)height, 0.0f).m_85950_(r, g, b, a).m_7421_(u, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y + (float)height, 0.0f).m_85950_(r, g, b, a).m_7421_(u + uWidth, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(u + uWidth, v).m_5752_();
        bufferbuilder.m_85982_(last, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void innerBlit(PoseStack stack, int x, int y, double width, double height, float u, float v, float uWidth, float vHeight) {
        Matrix4f last = stack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(last, (float)x, (float)y + (float)height, 0.0f).m_7421_(u, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y + (float)height, 0.0f).m_7421_(u + uWidth, v + vHeight).m_5752_();
        bufferbuilder.m_85982_(last, (float)x + (float)width, (float)y, 0.0f).m_7421_(u + uWidth, v).m_5752_();
        bufferbuilder.m_85982_(last, (float)x, (float)y, 0.0f).m_7421_(u, v).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static VertexBuilder create() {
        return new VertexBuilder();
    }

    public static void vertexPos(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z) {
        vertexConsumer.m_85982_(last, x, y, z).m_5752_();
    }

    public static void vertexPosUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v) {
        vertexConsumer.m_85982_(last, x, y, z).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v, int light) {
        vertexConsumer.m_85982_(last, x, y, z).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static void vertexPosColor(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a) {
        vertexConsumer.m_85982_(last, x, y, z).m_85950_(r, g, b, a).m_5752_();
    }

    public static void vertexPosColorUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        vertexConsumer.m_85982_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosColorUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        vertexConsumer.m_85982_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }

    public static Vec2 corners(Vector4f start, Vector4f end, float width) {
        float x = -start.m_123601_();
        float y = -start.m_123615_();
        float z = Math.abs(start.m_123616_());
        if (z <= 0.0f) {
            x += end.m_123601_();
            y += end.m_123615_();
        } else if (z > 0.0f) {
            float ratio = end.m_123616_() / start.m_123616_();
            x = end.m_123601_() + x * ratio;
            y = end.m_123615_() + y * ratio;
        }
        if (start.m_123616_() > 0.0f) {
            x = -x;
            y = -y;
        }
        float[] fArray = new float[]{x, y};
        float distance = DataHelper.distance(fArray);
        if (distance > 0.0f) {
            float normalize = width * 0.5f / (float)Math.sqrt(distance);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static Vector4f midpoint(Vector4f a, Vector4f b) {
        return new Vector4f((a.m_123601_() + b.m_123601_()) * 0.5f, (a.m_123615_() + b.m_123615_()) * 0.5f, (a.m_123616_() + b.m_123616_()) * 0.5f, (a.m_123617_() + b.m_123617_()) * 0.5f);
    }

    public static class VertexBuilder {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float zOffset = 0.0f;
        int light = 0xF000F0;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;

        public VertexBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public VertexBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public VertexBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public VertexBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public VertexBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public VertexBuilder setOffset(float xOffset, float yOffset, float zOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            return this;
        }

        public VertexBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public VertexBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public VertexBuilder renderTriangle(VertexConsumer vertexConsumer, PoseStack stack, float size) {
            return this.renderTriangle(vertexConsumer, stack, size, size);
        }

        public VertexBuilder renderTriangle(VertexConsumer vertexConsumer, PoseStack stack, float width, float height) {
            Matrix4f last = stack.m_85850_().m_85861_();
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, -width, -height, 0.0f, this.r, this.g, this.b, this.a, 0.0f, 1.0f, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, width, -height, 0.0f, this.r, this.g, this.b, this.a, 1.0f, 1.0f, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, 0.0f, height, 0.0f, this.r, this.g, this.b, this.a, 0.5f, 0.0f, this.light);
            return this;
        }

        public VertexBuilder renderTrail(VertexConsumer vertexConsumer, PoseStack stack, List<Vector4f> trailSegments, Function<Float, Float> widthFunc) {
            return this.renderTrail(vertexConsumer, stack.m_85850_().m_85861_(), trailSegments, widthFunc);
        }

        public VertexBuilder renderTrail(VertexConsumer vertexConsumer, Matrix4f pose, List<Vector4f> trailSegments, Function<Float, Float> widthFunc) {
            if (trailSegments.size() < 3) {
                return this;
            }
            for (Vector4f pos : trailSegments) {
                pos.m_176875_(this.xOffset, this.yOffset, this.zOffset, 0.0f);
                pos.m_123607_(pose);
            }
            int count = trailSegments.size() - 1;
            float increment = 1.0f / (float)(count - 1);
            ArrayList<TrailPoint> points = new ArrayList<TrailPoint>();
            for (int i = 0; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
                Vector4f start = trailSegments.get(i);
                Vector4f end = trailSegments.get(i + 1);
                Vector4f mid = RenderHelper.midpoint(start, end);
                Vec2 offset = RenderHelper.corners(start, end, width);
                Vector4f positions = new Vector4f(mid.m_123601_() + offset.f_82470_, mid.m_123601_() - offset.f_82470_, mid.m_123615_() + offset.f_82471_, mid.m_123615_() - offset.f_82471_);
                points.add(new TrailPoint(positions.m_123601_(), positions.m_123615_(), positions.m_123616_(), positions.m_123617_(), mid.m_123616_()));
            }
            return this.renderPoints(vertexConsumer, points, this.u0, this.v0, this.u1, this.v1);
        }

        public VertexBuilder renderPoints(VertexConsumer vertexConsumer, List<TrailPoint> trailPoints, float u0, float v0, float u1, float v1) {
            int count = trailPoints.size();
            float increment = 1.0f / (float)count;
            for (int i = 1; i < count; ++i) {
                float current = Mth.m_14179_((float)((float)i * increment), (float)v0, (float)v1);
                float next = Mth.m_14179_((float)((float)(i + 1) * increment), (float)v0, (float)v1);
                TrailPoint previousPoint = trailPoints.get(i - 1);
                TrailPoint point = trailPoints.get(i);
                previousPoint.renderStart(vertexConsumer, this.light, this.r, this.g, this.b, this.a, u0, current, u1, next);
                point.renderEnd(vertexConsumer, this.light, this.r, this.g, this.b, this.a, u0, current, u1, next);
            }
            return this;
        }

        public VertexBuilder renderBeam(VertexConsumer vertexConsumer, PoseStack stack, Vec3 start, Vec3 end, float width) {
            Minecraft minecraft = Minecraft.m_91087_();
            start.m_82520_((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            end.m_82520_((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            stack.m_85837_(-start.f_82479_, -start.f_82480_, -start.f_82481_);
            Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
            Vec3 delta = end.m_82546_(start);
            Vec3 normal = start.m_82546_(cameraPosition).m_82537_(delta).m_82541_().m_82542_((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            Matrix4f last = stack.m_85850_().m_85861_();
            Vec3[] positions = new Vec3[]{start.m_82546_(normal), start.m_82549_(normal), end.m_82549_(normal), end.m_82546_(normal)};
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, (float)positions[0].f_82479_, (float)positions[0].f_82480_, (float)positions[0].f_82481_, this.r, this.g, this.b, this.a, this.u0, this.v1, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, (float)positions[1].f_82479_, (float)positions[1].f_82480_, (float)positions[1].f_82481_, this.r, this.g, this.b, this.a, this.u1, this.v1, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, (float)positions[2].f_82479_, (float)positions[2].f_82480_, (float)positions[2].f_82481_, this.r, this.g, this.b, this.a, this.u1, this.v0, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, (float)positions[3].f_82479_, (float)positions[3].f_82480_, (float)positions[3].f_82481_, this.r, this.g, this.b, this.a, this.u0, this.v0, this.light);
            stack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
            return this;
        }

        public VertexBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, float size) {
            return this.renderQuad(vertexConsumer, stack, size, size);
        }

        public VertexBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-width, -height, 0.0f), new Vector3f(width, -height, 0.0f), new Vector3f(width, height, 0.0f), new Vector3f(-width, height, 0.0f)};
            return this.renderQuad(vertexConsumer, stack, positions, width, height);
        }

        public VertexBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Vector3f[] positions, float size) {
            return this.renderQuad(vertexConsumer, stack, positions, size, size);
        }

        public VertexBuilder renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Vector3f[] positions, float width, float height) {
            Matrix4f last = stack.m_85850_().m_85861_();
            stack.m_85837_((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            for (Vector3f position : positions) {
                position.m_122263_(width, height, width);
            }
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, positions[0].m_122239_(), positions[0].m_122260_(), positions[0].m_122269_(), this.r, this.g, this.b, this.a, this.u0, this.v1, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, positions[1].m_122239_(), positions[1].m_122260_(), positions[1].m_122269_(), this.r, this.g, this.b, this.a, this.u1, this.v1, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, positions[2].m_122239_(), positions[2].m_122260_(), positions[2].m_122269_(), this.r, this.g, this.b, this.a, this.u1, this.v0, this.light);
            RenderHelper.vertexPosColorUVLight(vertexConsumer, last, positions[3].m_122239_(), positions[3].m_122260_(), positions[3].m_122269_(), this.r, this.g, this.b, this.a, this.u0, this.v0, this.light);
            stack.m_85837_((double)(-this.xOffset), (double)(-this.yOffset), (double)(-this.zOffset));
            return this;
        }

        public VertexBuilder renderSphere(VertexConsumer vertexConsumer, PoseStack stack, float radius, int longs, int lats) {
            Matrix4f last = stack.m_85850_().m_85861_();
            float startU = 0.0f;
            float startV = 0.0f;
            float endU = (float)Math.PI * 2;
            float endV = (float)Math.PI;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p0.m_122239_(), p0.m_122260_(), p0.m_122269_(), this.r, this.g, this.b, this.a, textureU, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p3.m_122239_(), p3.m_122260_(), p3.m_122269_(), this.r, this.g, this.b, this.a, textureUN, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                }
            }
            return this;
        }
    }
}

