/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.helpers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioHelper {
    public static boolean hasCurioEquipped(LivingEntity entity, RegistryObject<Item> curio) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)curio.get(), entity).isPresent();
    }

    public static ArrayList<ItemStack> equippedCurios(LivingEntity entity) {
        Optional optional = CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (optional.isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                stacks.add(handler.getStackInSlot(i));
            }
        }
        return stacks;
    }

    public static ArrayList<ItemStack> equippedCurios(LivingEntity entity, Predicate<ItemStack> predicate) {
        Optional optional = CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (optional.isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!predicate.test(stack)) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> findCosmeticCurio(Predicate<ItemStack> filter, LivingEntity livingEntity) {
        ImmutableTriple result = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> {
            Map curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHelper = stacksHandler.getCosmeticStacks();
                for (i = 0; i < stackHandler.getSlots(); ++i) {
                    stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
                for (i = 0; i < cosmeticStackHelper.getSlots(); ++i) {
                    stack = cosmeticStackHelper.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }
}

