/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.helpers;

import com.sammy.ortus.systems.easing.Easing;
import java.awt.Color;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorHelper {
    public static Color getColor(int decimal) {
        int red = FastColor.ARGB32.m_13665_((int)decimal);
        int green = FastColor.ARGB32.m_13667_((int)decimal);
        int blue = FastColor.ARGB32.m_13669_((int)decimal);
        return new Color(red, green, blue);
    }

    public static void RGBToHSV(Color color, float[] hsv) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsv);
    }

    public static int getColor(Color color) {
        return FastColor.ARGB32.m_13660_((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }

    public static int getColor(int r, int g, int b) {
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    public static int getColor(int r, int g, int b, int a) {
        return FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
    }

    public static int getColor(float r, float g, float b, float a) {
        return FastColor.ARGB32.m_13660_((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    public static Color colorLerp(Easing easing, float pct, Color brightColor, Color darkColor) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int br = brightColor.getRed();
        int bg = brightColor.getGreen();
        int bb = brightColor.getBlue();
        int dr = darkColor.getRed();
        int dg = darkColor.getGreen();
        int db = darkColor.getBlue();
        int red = (int)easing.ease(pct, dr, br, 1.0f);
        int green = (int)easing.ease(pct, dg, bg, 1.0f);
        int blue = (int)easing.ease(pct, db, bb, 1.0f);
        return new Color(red, green, blue);
    }

    public static Color multicolorLerp(Easing easing, float pct, Color ... colors) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int colorCount = colors.length - 1;
        float lerp = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float colorIndex = (float)colorCount * lerp;
        int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
        Color color = colors[index];
        Color nextColor = index == colorCount ? color : colors[index + 1];
        return ColorHelper.colorLerp(easing, colorIndex - (float)((int)colorIndex), nextColor, color);
    }

    public static Color darker(Color color, int times) {
        float FACTOR = (float)Math.pow(0.7f, times);
        return new Color(Math.max((int)((float)color.getRed() * FACTOR), 0), Math.max((int)((float)color.getGreen() * FACTOR), 0), Math.max((int)((float)color.getBlue() * FACTOR), 0), color.getAlpha());
    }

    public static Color brighter(Color color, int times) {
        float FACTOR = (float)Math.pow(0.7f, times);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255), alpha);
    }
}

