/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.helpers;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;

public class BlockHelper {
    public static BlockState getBlockStateWithExistingProperties(BlockState oldState, BlockState newState) {
        BlockState finalState = newState;
        for (Property property : oldState.m_61147_()) {
            if (!newState.m_61138_(property)) continue;
            finalState = BlockHelper.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static BlockState setBlockStateWithExistingProperties(Level level, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = level.m_8055_(pos);
        BlockState finalState = BlockHelper.getBlockStateWithExistingProperties(oldState, newState);
        level.m_7260_(pos, oldState, finalState, flags);
        level.m_7731_(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
    }

    public static void saveBlockPos(CompoundTag compoundNBT, BlockPos pos) {
        compoundNBT.m_128405_("X", pos.m_123341_());
        compoundNBT.m_128405_("Y", pos.m_123342_());
        compoundNBT.m_128405_("Z", pos.m_123343_());
    }

    public static void saveBlockPos(CompoundTag compoundNBT, BlockPos pos, String extra) {
        compoundNBT.m_128405_(extra + "_X", pos.m_123341_());
        compoundNBT.m_128405_(extra + "_Y", pos.m_123342_());
        compoundNBT.m_128405_(extra + "_Z", pos.m_123343_());
    }

    public static BlockPos loadBlockPos(CompoundTag tag) {
        return tag.m_128441_("X") ? new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z")) : null;
    }

    public static BlockPos loadBlockPos(CompoundTag tag, String extra) {
        return tag.m_128441_(extra + "_X") ? new BlockPos(tag.m_128451_(extra + "_X"), tag.m_128451_(extra + "_Y"), tag.m_128451_(extra + "_Z")) : null;
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int range, Predicate<T> predicate) {
        return BlockHelper.getBlockEntities(type, level, pos, range, range, range, predicate);
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int z, Predicate<T> predicate) {
        ArrayList<T> blockEntities = BlockHelper.getBlockEntities(type, level, pos, x, z);
        blockEntities.removeIf(b -> !predicate.test(b));
        return blockEntities;
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int y, int z, Predicate<T> predicate) {
        ArrayList<T> blockEntities = BlockHelper.getBlockEntities(type, level, pos, x, y, z);
        blockEntities.removeIf(b -> !predicate.test(b));
        return blockEntities;
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int range) {
        return BlockHelper.getBlockEntities(type, level, pos, range, range, range);
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int z) {
        return BlockHelper.getBlockEntities(type, level, new AABB((double)(pos.m_123341_() - x), (double)pos.m_123342_(), (double)(pos.m_123343_() - z), (double)(pos.m_123341_() + x), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + z)));
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlockEntities(type, level, pos, -x, -y, -z, x, y, z);
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlockEntities(type, level, new AABB((double)(pos.m_123341_() + x1), (double)(pos.m_123342_() + y1), (double)(pos.m_123343_() + z1), (double)(pos.m_123341_() + x2), (double)(pos.m_123342_() + y2), (double)(pos.m_123343_() + z2)));
    }

    public static <T> ArrayList<T> getBlockEntities(Class<T> type, Level world, AABB bb) {
        ArrayList<BlockEntity> tileList = new ArrayList<BlockEntity>();
        for (int i = (int)Math.floor(bb.f_82288_); i < (int)Math.ceil(bb.f_82291_) + 16; i += 16) {
            for (int j = (int)Math.floor(bb.f_82290_); j < (int)Math.ceil(bb.f_82293_) + 16; j += 16) {
                ChunkAccess c = world.m_46865_(new BlockPos(i, 0, j));
                Set tiles = c.m_5928_();
                for (BlockPos p : tiles) {
                    BlockEntity t;
                    if (!bb.m_82393_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5) || !type.isInstance(t = world.m_7702_(p))) continue;
                    tileList.add(t);
                }
            }
        }
        return tileList;
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getBlocks(pos, range, range, range, predicate);
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x, int y, int z, Predicate<BlockPos> predicate) {
        ArrayList<BlockPos> blocks = BlockHelper.getBlocks(pos, x, y, z);
        blocks.removeIf(b -> !predicate.test((BlockPos)b));
        return blocks;
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlocks(pos, -x, -y, -z, x, y, z);
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    positions.add(pos.m_142082_(x, y, z));
                }
            }
        }
        return positions;
    }

    public static ArrayList<BlockPos> getPlaneOfBlocks(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getPlaneOfBlocks(pos, range, range, predicate);
    }

    public static ArrayList<BlockPos> getPlaneOfBlocks(BlockPos pos, int x, int z, Predicate<BlockPos> predicate) {
        ArrayList<BlockPos> blocks = BlockHelper.getPlaneOfBlocks(pos, x, z);
        blocks.removeIf(b -> !predicate.test((BlockPos)b));
        return blocks;
    }

    public static ArrayList<BlockPos> getPlaneOfBlocks(BlockPos pos, int x, int z) {
        return BlockHelper.getPlaneOfBlocks(pos, -x, -z, x, z);
    }

    public static ArrayList<BlockPos> getPlaneOfBlocks(BlockPos pos, int x1, int z1, int x2, int z2) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                positions.add(new BlockPos(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z));
            }
        }
        return positions;
    }

    public static void updateState(Level level, BlockPos pos) {
        BlockHelper.updateState(level.m_8055_(pos), level, pos);
    }

    public static void updateState(BlockState state, Level level, BlockPos pos) {
        level.m_7260_(pos, state, state, 2);
        level.m_151543_(pos);
    }

    public static void updateAndNotifyState(Level level, BlockPos pos) {
        BlockHelper.updateAndNotifyState(level.m_8055_(pos), level, pos);
    }

    public static void updateAndNotifyState(BlockState state, Level level, BlockPos pos) {
        BlockHelper.updateState(state, level, pos);
        state.m_60701_((LevelAccessor)level, pos, 2);
        level.m_46717_(pos, state.m_60734_());
    }
}

