/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.handlers;

import com.sammy.ortus.capability.PlayerDataCapability;
import com.sammy.ortus.capability.WorldDataCapability;
import com.sammy.ortus.handlers.RenderHandler;
import com.sammy.ortus.setup.worldevent.OrtusWorldEventRenderers;
import com.sammy.ortus.setup.worldevent.OrtusWorldEventTypes;
import com.sammy.ortus.systems.worldevent.WorldEventInstance;
import com.sammy.ortus.systems.worldevent.WorldEventRenderer;
import com.sammy.ortus.systems.worldevent.WorldEventType;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class WorldEventHandler {
    public static <T extends WorldEventInstance> T addWorldEvent(Level level, T instance) {
        WorldDataCapability.getCapability(level).ifPresent(capability -> {
            capability.inboundWorldEvents.add(instance);
            instance.start(level);
            instance.sync(level);
        });
        return instance;
    }

    public static void playerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                PlayerDataCapability.getCapability(player).ifPresent(capability -> WorldDataCapability.getCapability((Level)level2).ifPresent(worldCapability -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        for (WorldEventInstance instance : worldCapability.activeWorldEvents) {
                            if (!instance.isClientSynced()) continue;
                            WorldEventInstance.sync(instance, serverPlayer);
                        }
                    }
                }));
            }
        }
    }

    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && !event.world.f_46443_) {
            WorldEventHandler.tick(event.world);
        }
    }

    public static void tick(Level level) {
        WorldDataCapability.getCapability(level).ifPresent(capability -> {
            capability.activeWorldEvents.addAll(capability.inboundWorldEvents);
            capability.inboundWorldEvents.clear();
            Iterator<WorldEventInstance> iterator = capability.activeWorldEvents.iterator();
            while (iterator.hasNext()) {
                WorldEventInstance instance = iterator.next();
                if (instance.discarded) {
                    iterator.remove();
                    continue;
                }
                instance.tick(level);
            }
        });
    }

    public static void serializeNBT(WorldDataCapability capability, CompoundTag tag) {
        tag.m_128405_("worldEventCount", capability.activeWorldEvents.size());
        for (int i = 0; i < capability.activeWorldEvents.size(); ++i) {
            WorldEventInstance instance = capability.activeWorldEvents.get(i);
            CompoundTag instanceTag = new CompoundTag();
            instance.serializeNBT(instanceTag);
            tag.m_128365_("worldEvent_" + i, (Tag)instanceTag);
        }
    }

    public static void deserializeNBT(WorldDataCapability capability, CompoundTag tag) {
        capability.activeWorldEvents.clear();
        int starfallCount = tag.m_128451_("worldEventCount");
        for (int i = 0; i < starfallCount; ++i) {
            CompoundTag instanceTag = tag.m_128469_("worldEvent_" + i);
            WorldEventType reader = OrtusWorldEventTypes.EVENT_TYPES.get(instanceTag.m_128461_("type"));
            WorldEventInstance eventInstance = reader.createInstance(instanceTag);
            capability.activeWorldEvents.add(eventInstance);
        }
    }

    public static class ClientOnly {
        public static void renderWorldEvents(RenderLevelLastEvent event) {
            WorldDataCapability.getCapability((Level)Minecraft.m_91087_().f_91073_).ifPresent(capability -> {
                for (WorldEventInstance instance : capability.activeWorldEvents) {
                    WorldEventRenderer<WorldEventInstance> renderer = OrtusWorldEventRenderers.RENDERERS.get(instance.type);
                    if (renderer == null || !renderer.canRender(instance)) continue;
                    renderer.render(instance, event.getPoseStack(), (MultiBufferSource)RenderHandler.DELAYED_RENDER, event.getPartialTick());
                }
            });
        }
    }
}

