/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.sammy.ortus.compability.JeiCompat;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.rendering.particle.screen.GenericScreenParticle;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleOptions;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import com.sammy.ortus.systems.rendering.particle.screen.emitter.ItemParticleEmitter;
import com.sammy.ortus.systems.rendering.particle.screen.emitter.ParticleEmitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ScreenParticleHandler {
    public static Map<Pair<ParticleRenderType, ScreenParticle.RenderOrder>, ArrayList<ScreenParticle>> PARTICLES = new HashMap<Pair<ParticleRenderType, ScreenParticle.RenderOrder>, ArrayList<ScreenParticle>>();
    public static ArrayList<StackTracker> RENDERED_STACKS = new ArrayList();
    public static Map<Item, ParticleEmitter> EMITTERS = new HashMap<Item, ParticleEmitter>();
    public static final Tesselator TESSELATOR = new Tesselator();
    public static boolean canSpawnParticles;
    public static boolean renderingHotbar;

    public static void registerParticleEmitters(FMLClientSetupEvent event) {
        DataHelper.takeAll(new ArrayList(ForgeRegistries.ITEMS.getValues()), i -> i instanceof ItemParticleEmitter).forEach(i -> {
            ItemParticleEmitter emitter = (ItemParticleEmitter)i;
            ScreenParticleHandler.registerItemParticleEmitter(i, emitter::particleTick);
        });
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        PARTICLES.forEach((pair, particles) -> {
            Iterator iterator = particles.iterator();
            while (iterator.hasNext()) {
                ScreenParticle particle = (ScreenParticle)iterator.next();
                particle.tick();
                if (particle.isAlive()) continue;
                iterator.remove();
            }
        });
        canSpawnParticles = true;
    }

    public static void renderItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91074_ != null) {
            ParticleEmitter emitter;
            if (minecraft.m_91104_()) {
                return;
            }
            if (!stack.m_41619_() && (emitter = EMITTERS.get(stack.m_41720_())) != null) {
                PoseStack posestack = RenderSystem.m_157191_();
                ScreenParticle.RenderOrder renderOrder = ScreenParticle.RenderOrder.AFTER_EVERYTHING;
                Screen screen = minecraft.f_91080_;
                if (screen != null) {
                    if (!JeiCompat.LOADED || !JeiCompat.LoadedOnly.isRecipesUi(screen)) {
                        renderOrder = ScreenParticle.RenderOrder.BEFORE_TOOLTIPS;
                    }
                    if (renderingHotbar) {
                        renderOrder = ScreenParticle.RenderOrder.BEFORE_UI;
                    }
                }
                Matrix4f last = posestack.m_85850_().m_85861_();
                float x = last.f_27606_;
                float y = last.f_27610_;
                if (canSpawnParticles) {
                    emitter.tick(stack, x, y, renderOrder);
                }
                RENDERED_STACKS.add(new StackTracker(stack, renderOrder, x, y));
            }
        }
    }

    public static void renderParticles(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (JeiCompat.LOADED && JeiCompat.LoadedOnly.isRecipesUi(screen)) {
                ScreenParticleHandler.renderParticles(ScreenParticle.RenderOrder.AFTER_EVERYTHING);
            }
            if (screen == null || screen instanceof ChatScreen || screen instanceof GameModeSwitcherScreen) {
                ScreenParticleHandler.renderParticles(ScreenParticle.RenderOrder.AFTER_EVERYTHING, ScreenParticle.RenderOrder.BEFORE_UI);
            }
            RENDERED_STACKS.clear();
            canSpawnParticles = false;
        }
    }

    public static void renderParticles(ScreenParticle.RenderOrder ... renderOrders) {
        PARTICLES.forEach((pair, particles) -> {
            ParticleRenderType type = (ParticleRenderType)pair.getFirst();
            if (Arrays.stream(renderOrders).anyMatch(o -> o.equals(pair.getSecond()))) {
                type.m_6505_(TESSELATOR.m_85915_(), Minecraft.m_91087_().f_90987_);
                for (ScreenParticle next : particles) {
                    if (next instanceof GenericScreenParticle) {
                        GenericScreenParticle genericScreenParticle = (GenericScreenParticle)next;
                        genericScreenParticle.trackStack();
                    }
                    next.render(TESSELATOR.m_85915_());
                }
                type.m_6294_(TESSELATOR);
            }
        });
    }

    public static <T extends ScreenParticleOptions> ScreenParticle addParticle(T options, double pX, double pY, double pXSpeed, double pYSpeed) {
        Minecraft minecraft = Minecraft.m_91087_();
        ScreenParticleType<?> type = options.type;
        ScreenParticleType.ParticleProvider<T> provider = type.provider;
        ScreenParticle particle = provider.createParticle(minecraft.f_91073_, options, pX, pY, pXSpeed, pYSpeed);
        ArrayList list = PARTICLES.computeIfAbsent((Pair<ParticleRenderType, ScreenParticle.RenderOrder>)Pair.of((Object)particle.getRenderType(), (Object)((Object)particle.renderOrder)), a -> new ArrayList());
        list.add(particle);
        return particle;
    }

    public static void wipeParticles(ScreenParticle.RenderOrder ... renderOrders) {
        PARTICLES.forEach((pair, particles) -> {
            if (!particles.isEmpty() && (renderOrders.length == 0 || Arrays.stream(renderOrders).anyMatch(o -> o.equals(pair.getSecond())))) {
                particles.clear();
            }
        });
    }

    public static void registerItemParticleEmitter(Item item, ParticleEmitter.EmitterSupplier emitter) {
        EMITTERS.put(item, new ParticleEmitter(emitter));
    }

    public static void registerItemParticleEmitter(ParticleEmitter.EmitterSupplier emitter, Item ... items) {
        for (Item item : items) {
            EMITTERS.put(item, new ParticleEmitter(emitter));
        }
    }

    public record StackTracker(ItemStack stack, ScreenParticle.RenderOrder order, float xOrigin, float yOrigin) {
    }
}

