/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.handlers;

import com.sammy.ortus.helpers.ItemHelper;
import com.sammy.ortus.systems.item.IEventResponderItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemEventHandler {
    public static void respondToDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        LivingEntity attacker = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity directAttacker;
            attacker = directAttacker = (LivingEntity)entity;
        }
        if (attacker == null) {
            attacker = target.m_142581_();
        }
        if (attacker != null) {
            LivingEntity finalAttacker = attacker;
            ItemHelper.getEventResponders(attacker).forEach(s -> ((IEventResponderItem)s.m_41720_()).killEvent(event, finalAttacker, target, (ItemStack)s));
        }
    }

    public static void respondToHurt(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ItemHelper.getEventResponders(attacker).forEach(s -> ((IEventResponderItem)s.m_41720_()).hurtEvent(event, attacker, target, (ItemStack)s));
            ItemHelper.getEventResponders(target).forEach(s -> ((IEventResponderItem)s.m_41720_()).takeDamageEvent(event, target, attacker, (ItemStack)s));
        }
    }
}

