/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.ortus.capability.EntityDataCapability;
import com.sammy.ortus.setup.OrtusFireEffectRenderers;
import com.sammy.ortus.systems.fireeffect.FireEffectInstance;
import com.sammy.ortus.systems.fireeffect.FireEffectRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;

public class FireEffectHandler {
    public static void entityUpdate(Entity entity) {
        FireEffectInstance instance = FireEffectHandler.getFireEffectInstance(entity);
        if (instance != null) {
            instance.tick(entity);
            if (!instance.isValid()) {
                FireEffectHandler.setCustomFireInstance(entity, null);
            }
        }
    }

    public static void onVanillaFireTimeUpdate(Entity entity) {
        FireEffectHandler.setCustomFireInstance(entity, null);
    }

    public static FireEffectInstance getFireEffectInstance(Entity entity) {
        EntityDataCapability capability = (EntityDataCapability)EntityDataCapability.getCapability(entity).orElse((Object)new EntityDataCapability());
        return capability.fireEffectInstance;
    }

    public static void setCustomFireInstance(Entity entity, FireEffectInstance instance) {
        EntityDataCapability.getCapability(entity).ifPresent(c -> {
            c.fireEffectInstance = instance;
            if (instance != null && entity.m_20094_() > 0) {
                entity.m_7311_(0);
            }
            if (!entity.f_19853_.f_46443_) {
                EntityDataCapability.syncTrackingAndSelf(entity);
            }
        });
    }

    public static class ClientOnly {
        public static void renderUIMeteorFire(Minecraft pMinecraft, PoseStack pPoseStack) {
            if (pMinecraft.f_91074_ != null && FireEffectHandler.getFireEffectInstance((Entity)pMinecraft.f_91074_) == null) {
                return;
            }
            FireEffectInstance instance = FireEffectHandler.getFireEffectInstance((Entity)pMinecraft.f_91074_);
            FireEffectRenderer<FireEffectInstance> renderer = OrtusFireEffectRenderers.RENDERERS.get(instance.type);
            if (renderer.canRender(instance)) {
                renderer.renderScreen(instance, pMinecraft, pPoseStack);
            }
        }

        public static void renderWorldMeteorFire(PoseStack pMatrixStack, MultiBufferSource pBuffer, Camera camera, Entity pEntity) {
            if (FireEffectHandler.getFireEffectInstance(pEntity) == null) {
                return;
            }
            FireEffectInstance instance = FireEffectHandler.getFireEffectInstance(pEntity);
            FireEffectRenderer<FireEffectInstance> renderer = OrtusFireEffectRenderers.RENDERERS.get(instance.type);
            if (renderer.canRender(instance)) {
                renderer.renderWorld(instance, pMatrixStack, pBuffer, camera, pEntity);
            }
        }

        private static void fireVertex(PoseStack.Pose pMatrixEntry, VertexConsumer pBuffer, float pX, float pY, float pZ, float pTexU, float pTexV) {
            pBuffer.m_85982_(pMatrixEntry.m_85861_(), pX, pY, pZ).m_6122_(255, 255, 255, 255).m_7421_(pTexU, pTexV).m_7122_(0, 10).m_85969_(240).m_85977_(pMatrixEntry.m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }
}

