/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.events;

import com.sammy.ortus.OrtusLib;
import com.sammy.ortus.capability.PlayerDataCapability;
import com.sammy.ortus.handlers.RenderHandler;
import com.sammy.ortus.handlers.ScreenParticleHandler;
import com.sammy.ortus.handlers.ScreenshakeHandler;
import com.sammy.ortus.handlers.WorldEventHandler;
import com.sammy.ortus.setup.OrtusOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SimpleOptionsSubScreen;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientRuntimeEvents {
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                if (minecraft.m_91104_()) {
                    return;
                }
                Camera camera = minecraft.f_91063_.m_109153_();
                ScreenParticleHandler.clientTick(event);
                WorldEventHandler.tick((Level)minecraft.f_91073_);
                ScreenshakeHandler.clientTick(camera, OrtusLib.RANDOM);
                PlayerDataCapability.ClientOnly.clientTick(event);
                ScreenParticleHandler.clientTick(event);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderLast(RenderLevelLastEvent event) {
        RenderHandler.renderLast(event);
        WorldEventHandler.ClientOnly.renderWorldEvents(event);
    }

    @SubscribeEvent
    public static void setupScreen(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof SimpleOptionsSubScreen) {
            SimpleOptionsSubScreen subScreen = (SimpleOptionsSubScreen)screen;
            subScreen.f_96668_.m_94476_((Option[])OrtusOptions.OPTIONS.stream().filter(e -> e.canAdd(event)).toArray(Option[]::new));
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        ScreenParticleHandler.renderParticles(event);
    }
}

