/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.data;

import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.setup.OrtusAttributes;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.data.LanguageProvider;

public class OrtusLang
extends LanguageProvider {
    public OrtusLang(DataGenerator gen) {
        super(gen, "ortus", "en_us");
    }

    protected void addTranslations() {
        HashSet attributes = new HashSet(OrtusAttributes.ATTRIBUTES.getEntries());
        attributes.forEach(a -> {
            String name = DataHelper.toTitleCase(a.getId().m_135815_(), "_");
            this.add("attribute.name.ortus." + ((Attribute)a.get()).getRegistryName().m_135815_(), name);
        });
        this.addOption("screenshake_intensity", "Screenshake Intensity");
        this.addOptionTooltip("screenshake_intensity", "Controls how much screenshake is applied to your screen.");
        this.addOption("fire_offset", "Fire Overlay Offset");
        this.addOptionTooltip("fire_offset", "Offsets the fire overlay effect downwards, clearing up your vision.");
    }

    public void addOption(String option, String result) {
        this.add(OrtusLang.getOption(option), result);
    }

    public static String getOption(String option) {
        return "options.ortus." + option;
    }

    public void addOptionTooltip(String option, String result) {
        this.add(OrtusLang.getOptionTooltip(option), result);
    }

    public static String getOptionTooltip(String option) {
        return "options.ortus." + option + ".tooltip";
    }

    public String m_6055_() {
        return "Ortus Lang Entries";
    }
}

