/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.capability;

import com.sammy.ortus.OrtusLib;
import com.sammy.ortus.network.SyncPlayerCapabilityDataPacket;
import com.sammy.ortus.network.SyncPlayerCapabilityDataServerPacket;
import com.sammy.ortus.network.interaction.UpdateLeftClickPacket;
import com.sammy.ortus.network.interaction.UpdateRightClickPacket;
import com.sammy.ortus.setup.OrtusPackets;
import com.sammy.ortus.systems.capability.OrtusCapability;
import com.sammy.ortus.systems.capability.OrtusCapabilityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerDataCapability
implements OrtusCapability {
    public static Capability<PlayerDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerDataCapability>(){});
    public boolean hasJoinedBefore;
    public boolean rightClickHeld;
    public int rightClickTime;
    public boolean leftClickHeld;
    public int leftClickTime;

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerDataCapability.class);
    }

    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerDataCapability capability = new PlayerDataCapability();
            event.addCapability(OrtusLib.prefix("player_data"), new OrtusCapabilityProvider<PlayerDataCapability>(CAPABILITY, () -> capability));
        }
    }

    public static void playerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerDataCapability.getCapability(player).ifPresent(capability -> {
                capability.hasJoinedBefore = true;
            });
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerDataCapability.syncSelf(serverPlayer);
            }
        }
    }

    public static void syncPlayerCapability(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.f_19853_ instanceof ServerLevel) {
                PlayerDataCapability.syncTracking(player);
            }
        }
    }

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerDataCapability.getCapability(event.player).ifPresent(c -> {
            c.rightClickTime = c.rightClickHeld ? c.rightClickTime + 1 : 0;
            c.leftClickTime = c.leftClickHeld ? c.leftClickTime + 1 : 0;
        });
    }

    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        PlayerDataCapability.getCapability(event.getOriginal()).ifPresent(o -> PlayerDataCapability.getCapability(event.getPlayer()).ifPresent(c -> c.deserializeNBT(o.serializeNBT())));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("firstTimeJoin", this.hasJoinedBefore);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.hasJoinedBefore = tag.m_128471_("firstTimeJoin");
    }

    public static void syncSelf(ServerPlayer player) {
        PlayerDataCapability.sync((Player)player, PacketDistributor.PLAYER.with(() -> player));
    }

    public static void syncTrackingAndSelf(Player player) {
        PlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }

    public static void syncTracking(Player player) {
        PlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY.with(() -> player));
    }

    public static void sync(Player player, PacketDistributor.PacketTarget target) {
        PlayerDataCapability.getCapability(player).ifPresent(c -> OrtusPackets.INSTANCE.send(target, (Object)new SyncPlayerCapabilityDataPacket(player.m_142081_(), c.serializeNBT())));
    }

    public static void syncServer(Player player) {
        PlayerDataCapability.getCapability(player).ifPresent(c -> OrtusPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new SyncPlayerCapabilityDataServerPacket(player.m_142081_(), c.serializeNBT())));
    }

    public static LazyOptional<PlayerDataCapability> getCapability(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static class ClientOnly {
        public static void clientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            PlayerDataCapability.getCapability((Player)player).ifPresent(c -> {
                boolean left = minecraft.f_91066_.f_92096_.m_90857_();
                boolean right = minecraft.f_91066_.f_92095_.m_90857_();
                if (left != c.leftClickHeld) {
                    c.leftClickHeld = left;
                    OrtusPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new UpdateLeftClickPacket(c.leftClickHeld));
                }
                if (right != c.rightClickHeld) {
                    c.rightClickHeld = right;
                    OrtusPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new UpdateRightClickPacket(c.rightClickHeld));
                }
            });
        }
    }
}

