/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.capability;

import com.sammy.ortus.OrtusLib;
import com.sammy.ortus.network.SyncEntityCapabilityDataPacket;
import com.sammy.ortus.setup.OrtusPackets;
import com.sammy.ortus.systems.capability.OrtusCapability;
import com.sammy.ortus.systems.capability.OrtusCapabilityProvider;
import com.sammy.ortus.systems.fireeffect.FireEffectInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class EntityDataCapability
implements OrtusCapability {
    public static Capability<EntityDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityDataCapability>(){});
    public FireEffectInstance fireEffectInstance;

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(EntityDataCapability.class);
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        EntityDataCapability capability = new EntityDataCapability();
        event.addCapability(OrtusLib.prefix("entity_data"), new OrtusCapabilityProvider<EntityDataCapability>(CAPABILITY, () -> capability));
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        if (event.getEntity().f_19853_ instanceof ServerLevel) {
            EntityDataCapability.syncTracking((Entity)event.getEntityLiving());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.fireEffectInstance != null) {
            CompoundTag fireTag = new CompoundTag();
            this.fireEffectInstance.serializeNBT(fireTag);
            tag.m_128365_("fireEffect", (Tag)fireTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("fireEffect")) {
            this.fireEffectInstance = FireEffectInstance.deserializeNBT(tag.m_128469_("fireEffect"));
        }
    }

    public static void syncTrackingAndSelf(Entity entity) {
        EntityDataCapability.sync(entity, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
    }

    public static void syncTracking(Entity entity) {
        EntityDataCapability.sync(entity, PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static void sync(Entity entity, PacketDistributor.PacketTarget target) {
        EntityDataCapability.getCapability(entity).ifPresent(c -> OrtusPackets.INSTANCE.send(target, (Object)new SyncEntityCapabilityDataPacket(entity.m_142049_(), c.serializeNBT())));
    }

    public static LazyOptional<EntityDataCapability> getCapability(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }
}

