/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.polylib.items.helpers.IDamageBarHelper;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.api.ISoulShard;
import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSoulShard
extends Item
implements ISoulShard,
IDamageBarHelper {
    public ItemSoulShard() {
        super(new Item.Properties().m_41491_(SoulShards.TAB_SS));
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof SpawnerBlock) {
            if (!SoulShards.CONFIG.getBalance().allowSpawnerAbsorption()) {
                context.m_43723_().m_6352_((Component)new TranslatableComponent("chat.soulshards.absorb_disabled"), null);
                return InteractionResult.PASS;
            }
            if (binding.getKills() >= Tier.maxKills) {
                return InteractionResult.PASS;
            }
            SpawnerBlockEntity mobSpawner = (SpawnerBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
            if (mobSpawner == null) {
                return InteractionResult.PASS;
            }
            try {
                ResourceLocation entityId = mobSpawner.m_59801_().m_151314_(context.m_43725_()).m_6095_().getRegistryName();
                if (!SoulShards.CONFIG.getEntityList().isEnabled(entityId)) {
                    return InteractionResult.PASS;
                }
                if (entityId == null || binding.getBoundEntity() == null || !binding.getBoundEntity().equals((Object)entityId)) {
                    return InteractionResult.FAIL;
                }
                this.updateBinding(stack, binding.addKills(SoulShards.CONFIG.getBalance().getAbsorptionBonus()));
                context.m_43725_().m_46961_(context.m_8083_(), false);
                return InteractionResult.SUCCESS;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state.m_60734_() == RegistrarSoulShards.SOUL_CAGE) {
            if (binding.getBoundEntity() == null) {
                return InteractionResult.FAIL;
            }
            TileEntitySoulCage cage = (TileEntitySoulCage)context.m_43725_().m_7702_(context.m_8083_());
            if (cage == null) {
                return InteractionResult.PASS;
            }
            ItemStackHandler itemHandler = cage.getInventory();
            if (itemHandler != null && itemHandler.getStackInSlot(0).m_41619_()) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.m_41777_(), (boolean)false);
                cage.m_6596_();
                cage.setState(true);
                context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(itemStack, context);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
        for (IShardTier tier : Tier.INDEXED) {
            ItemStack stack = new ItemStack((ItemLike)this);
            Binding binding = new Binding(null, tier.getKillRequirement());
            this.updateBinding(stack, binding);
            items.add((Object)stack);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        EntityType entityEntry;
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return;
        }
        if (binding.getBoundEntity() != null && (entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(binding.getBoundEntity())) != null) {
            tooltip.add((Component)new TranslatableComponent("tooltip.soulshards.bound", new Object[]{entityEntry.getRegistryName()}));
        }
        tooltip.add((Component)new TranslatableComponent("tooltip.soulshards.tier", new Object[]{binding.getTier().getIndex()}));
        tooltip.add((Component)new TranslatableComponent("tooltip.soulshards.kills", new Object[]{binding.getKills()}));
        if (flag.m_7050_() && binding.getOwner() != null) {
            tooltip.add((Component)new TranslatableComponent("tooltip.soulshards.owner", new Object[]{binding.getOwner().toString()}));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return binding != null && binding.getKills() >= Tier.maxKills;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getBinding(stack) == null ? 64 : 1;
    }

    public boolean m_142522_(@Nonnull ItemStack itemStack) {
        Binding binding = this.getBinding(itemStack);
        return SoulShards.CONFIG.getClient().displayDurabilityBar() && binding != null && binding.getKills() < Tier.maxKills;
    }

    public float getWidthForBar(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return 1.0f;
        }
        return 1.0f - (float)binding.getKills() / (float)Tier.maxKills;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    @Override
    @Nullable
    public Binding getBinding(ItemStack stack) {
        return Binding.fromNBT(stack);
    }

    public void updateBinding(ItemStack stack, Binding binding) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_("binding", (Tag)binding.serializeNBT());
    }
}

