/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.core;

import java.util.Set;
import javax.annotation.Nonnull;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.BindingEvent;
import net.creeperhost.soulshardsrespawn.api.ISoulWeapon;
import net.creeperhost.soulshardsrespawn.core.ConfigSoulShards;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.MultiblockPattern;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.creeperhost.soulshardsrespawn.item.ItemSoulShard;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="soulshards")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().allowFakePlayers() && event.getSource().m_7639_() instanceof FakePlayer) {
            return;
        }
        if (!SoulShards.CONFIG.getEntityList().isEnabled(event.getEntityLiving().m_6095_().getRegistryName())) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().allowBossSpawns() && !event.getEntityLiving().m_6072_()) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().countCageBornForShard() && event.getEntityLiving().getPersistentData().m_128471_("cageBorn")) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Player player = (Player)event.getSource().m_7639_();
            BindingEvent.GetEntityName getEntityName = new BindingEvent.GetEntityName(event.getEntityLiving());
            MinecraftForge.EVENT_BUS.post((Event)getEntityName);
            ResourceLocation entityId = getEntityName.getEntityId() == null ? ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntityLiving().m_6095_()) : getEntityName.getEntityId();
            ItemStack shardItem = EventHandler.getFirstShard(player, entityId);
            if (shardItem.m_41619_()) {
                return;
            }
            ItemSoulShard soulShard = (ItemSoulShard)shardItem.m_41720_();
            boolean newItem = false;
            Binding binding = soulShard.getBinding(shardItem);
            if (binding == null) {
                BindingEvent.NewBinding newBinding = new BindingEvent.NewBinding(event.getEntityLiving(), new Binding(null, 0));
                if (MinecraftForge.EVENT_BUS.post((Event)newBinding)) {
                    return;
                }
                if (shardItem.m_41613_() > 1) {
                    shardItem = shardItem.m_41620_(1);
                    newItem = true;
                }
                binding = (Binding)newBinding.getBinding();
            }
            ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
            int soulsGained = 1 + EnchantmentHelper.m_44843_((Enchantment)RegistrarSoulShards.SOUL_STEALER, (ItemStack)mainHand);
            if (mainHand.m_41720_() instanceof ISoulWeapon) {
                soulsGained += ((ISoulWeapon)mainHand.m_41720_()).getSoulBonus(mainHand, player, event.getEntityLiving());
            }
            BindingEvent.GainSouls gainSouls = new BindingEvent.GainSouls(event.getEntityLiving(), binding, soulsGained);
            MinecraftForge.EVENT_BUS.post((Event)gainSouls);
            if (binding.getBoundEntity() == null) {
                binding.setBoundEntity(entityId);
            }
            if (binding.getOwner() == null) {
                binding.setOwner(player.m_36316_().getId());
            }
            soulShard.updateBinding(shardItem, binding.addKills(gainSouls.getAmount()));
            if (newItem) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shardItem);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        MultiblockPattern pattern = ConfigSoulShards.getMultiblock();
        ItemStack held = event.getPlayer().m_21120_(event.getHand());
        if (!ItemStack.m_41746_((ItemStack)held, (ItemStack)pattern.getCatalyst())) {
            return;
        }
        BlockState state = event.getWorld().m_8055_(event.getPos());
        if (!pattern.isOriginBlock(state)) {
            return;
        }
        InteractionResultHolder<Set<BlockPos>> matched = pattern.match(event.getWorld(), event.getPos());
        if (matched.m_19089_() != InteractionResult.SUCCESS) {
            return;
        }
        for (BlockPos pos : (Set)matched.m_19095_()) {
            event.getWorld().m_46961_(pos, false);
        }
        held.m_41774_(1);
        ItemHandlerHelper.giveItemToPlayer((Player)event.getPlayer(), (ItemStack)new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD));
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        if (!SoulShards.CONFIG.getBalance().allowShardCombination()) {
            return;
        }
        if (event.getLeft().m_41720_() instanceof ItemSoulShard && event.getRight().m_41720_() instanceof ItemSoulShard) {
            Binding left = ((ItemSoulShard)event.getLeft().m_41720_()).getBinding(event.getLeft());
            Binding right = ((ItemSoulShard)event.getRight().m_41720_()).getBinding(event.getRight());
            if (left == null || right == null) {
                return;
            }
            if (left.getBoundEntity() != null && left.getBoundEntity().equals((Object)right.getBoundEntity())) {
                ItemStack output = new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD);
                ((ItemSoulShard)output.m_41720_()).updateBinding(output, left.addKills(right.getKills()));
                event.setOutput(output);
                event.setCost(left.getTier().getIndex() * 6);
            }
        }
    }

    @SubscribeEvent
    public static void dropExperience(LivingExperienceDropEvent event) {
        if (!SoulShards.CONFIG.getBalance().shouldDropExperience() && event.getEntityLiving().getPersistentData().m_128471_("cageBorn")) {
            event.setCanceled(true);
        }
    }

    @Nonnull
    public static ItemStack getFirstShard(Player player, ResourceLocation entityId) {
        ItemStack shardItem = player.m_21120_(InteractionHand.OFF_HAND);
        if (shardItem.m_41619_() || !(shardItem.m_41720_() instanceof ItemSoulShard)) {
            for (int i = 0; i < 9; ++i) {
                shardItem = player.m_150109_().m_8020_(i);
                if (shardItem.m_41619_() || !(shardItem.m_41720_() instanceof ItemSoulShard)) continue;
                Binding binding = ((ItemSoulShard)shardItem.m_41720_()).getBinding(shardItem);
                if (binding == null || binding.getBoundEntity() == null) {
                    return shardItem;
                }
                if (!binding.getBoundEntity().equals((Object)entityId) || binding.getKills() >= Tier.maxKills) continue;
                return shardItem;
            }
        } else {
            Binding binding = ((ItemSoulShard)shardItem.m_41720_()).getBinding(shardItem);
            if (binding == null || binding.getBoundEntity() == null) {
                return shardItem;
            }
            if (binding.getBoundEntity().equals((Object)entityId) && binding.getKills() < Tier.maxKills) {
                return shardItem;
            }
        }
        return ItemStack.f_41583_;
    }
}

