/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.storage;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

public class DISKCellHandler
implements ICellHandler {
    public static final DISKCellHandler INSTANCE = new DISKCellHandler();

    public boolean isCell(ItemStack is) {
        return is.m_41720_() instanceof DISKDrive;
    }

    public DISKCellInventory getCellInventory(ItemStack is, ISaveProvider container) {
        return DISKCellInventory.createInventory(is, container);
    }

    public void addCellInformationToTooltip(ItemStack stack, List<Component> lines) {
        DISKCellInventory handler = this.getCellInventory(stack, null);
        if (handler == null) {
            return;
        }
        if (handler.hasDiskUUID()) {
            lines.add((Component)new TextComponent("Disk UUID: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(handler.getDiskUUID().toString()).m_130940_(ChatFormatting.AQUA)));
            lines.add(Tooltips.bytesUsed((long)handler.getNbtItemCount(), (long)handler.getTotalBytes()));
        }
        if (handler.isPreformatted()) {
            MutableComponent list = (handler.getPartitionListMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).text();
            if (handler.isFuzzy()) {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").m_7220_((Component)list).m_130946_(" ").m_7220_((Component)GuiText.Fuzzy.text()));
            } else {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").m_7220_((Component)list).m_130946_(" ").m_7220_((Component)GuiText.Precise.text()));
            }
        }
    }
}

