/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookMarkRead;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorScreen;
import vazkii.patchouli.xplat.IXplatAbstractions;

public abstract class GuiBook
extends Screen {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static long lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    @Nullable
    private List<Component> tooltip;
    @Nullable
    private ItemStack tooltipStack;
    @Nullable
    private Pair<BookEntry, Integer> targetPage;
    protected int spread = 0;
    protected int maxSpreads = 0;
    public int ticksInBook;
    public int maxScale;
    protected boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, Component title) {
        super(title);
        this.book = book;
    }

    public void m_7856_() {
        Window res = this.f_96541_.m_91268_();
        double oldGuiScale = res.m_85385_(this.f_96541_.f_91066_.f_92072_, this.f_96541_.m_91390_());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.m_85385_(persistentScale, this.f_96541_.m_91390_());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.m_85449_();
            res.m_85378_(newGuiScale);
            this.f_96543_ = res.m_85445_();
            this.f_96544_ = res.m_85446_();
            res.m_85378_(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.f_96543_ / 2 - 136;
        this.bookTop = this.f_96544_ / 2 - 90;
        this.book.getContents().currentGui = this;
        this.m_142416_(new GuiButtonBook(this, this.f_96543_ / 2 - 9, this.bookTop + 180 - 5, 308, 0, 18, 9, this::canSeeBackButton, this::handleButtonBack, new Component[]{new TranslatableComponent("patchouli.gui.lexicon.button.back"), new TranslatableComponent("patchouli.gui.lexicon.button.back.info").m_130940_(ChatFormatting.GRAY)}));
        this.m_142416_(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.m_142416_(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public final void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        ms.m_85836_();
        if (this.scaleFactor != 1.0f) {
            ms.m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(ms, mouseX, mouseY, partialTicks);
        ms.m_85849_();
    }

    private void drawScreenAfterScale(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.m_7333_(ms);
        ms.m_85836_();
        ms.m_85837_((double)this.bookLeft, (double)this.bookTop, 0.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(ms, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        ms.m_85849_();
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        IXplatAbstractions.INSTANCE.fireDrawBookScreen(this.book.id, this, mouseX, mouseY, partialTicks, ms);
        this.drawTooltip(ms, mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeDrawablesIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.Bookmark bookmark : bookmarks) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.m_142416_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
        if (this.shouldAddMarkReadButton()) {
            this.m_142416_(new GuiButtonBookMarkRead(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 10));
        }
    }

    public final void removeDrawablesIf(Predicate<Widget> pred) {
        ((AccessorScreen)((Object)this)).getRenderables().removeIf(pred);
        this.m_6702_().removeIf(listener -> {
            Widget w;
            return listener instanceof Widget && pred.test(w = (Widget)listener);
        });
        ((AccessorScreen)((Object)this)).getNarratables().removeIf(listener -> {
            Widget w;
            return listener instanceof Widget && pred.test(w = (Widget)listener);
        });
    }

    public final void removeDrawablesIn(Collection<?> coll) {
        this.removeDrawablesIf(coll::contains);
    }

    public <T extends GuiEventListener & Widget> T m_142416_(T drawableElement) {
        return (T)super.m_142416_(drawableElement);
    }

    public void m_96570_(PoseStack matrices, @Nullable Style style, int mouseX, int mouseY) {
        super.m_96570_(matrices, style, mouseX, mouseY);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    protected boolean shouldAddMarkReadButton() {
        if (this instanceof GuiBookIndex) {
            return false;
        }
        return this.book.getContents().entries.values().stream().anyMatch(v -> !v.isLocked() && v.getReadState().equals((Object)EntryDisplayState.UNREAD));
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void m_96624_() {
        if (!GuiBook.m_96638_()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(ms, this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(PoseStack ms, int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.m_96555_(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.getContents().getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getFirst())) {
                MutableComponent t = new TextComponent("(").m_7220_((Component)new TranslatableComponent("patchouli.gui.lexicon.shift_for_recipe")).m_130946_(")").m_130940_(ChatFormatting.GOLD);
                tooltip.add(t);
                this.targetPage = provider;
            }
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.m_96597_(ms, this.tooltip, mouseX, mouseY);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(PoseStack ms, Book book, int x, int y, int u, int v, int w, int h) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)book.bookTexture);
        GuiBook.m_93133_((PoseStack)ms, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public boolean m_7043_() {
        return this.book.pauseGame;
    }

    private void handleButtonBack(Button button) {
        this.back(false);
    }

    public void handleButtonArrow(Button button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(Button button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.m_96638_() && !bookmarkButton.multiblock) {
            List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.spread), true);
        }
    }

    public final boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.m_96638_()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getFirst(), (Integer)this.targetPage.getSecond()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode) && !this.canSeeBackButton()) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        if (IXplatAbstractions.INSTANCE.handleRecipeKeybind(keyCode, scanCode, this.tooltipStack)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.getContents().guiStack.isEmpty()) {
            if (GuiBook.m_96638_()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.getContents().guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.getContents().guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.spread = left ? --this.spread : ++this.spread;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.spread > 0 : this.spread + 1 < this.maxSpreads;
    }

    public boolean canSeeBackButton() {
        return !this.book.getContents().guiStack.isEmpty();
    }

    public void setTooltip(Component ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<Component> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = this.getRelativeX(absMx);
        double my = this.getRelativeY(absMy);
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void drawProgressBar(PoseStack ms, Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || !book.advancementsEnabled()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.getContents().entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        GuiBook.m_93172_((PoseStack)ms, (int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.f_96547_.m_92889_(ms, (Component)new TranslatableComponent("patchouli.gui.lexicon.progress_meter"), (float)barLeft, (float)(barTop - 9), book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            TranslatableComponent progressStr = new TranslatableComponent("patchouli.gui.lexicon.progress_tooltip", new Object[]{unlockedEntries, totalEntries});
            tooltip.add((Component)progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add((Component)new TranslatableComponent("patchouli.gui.lexicon.progress_tooltip.secret1").m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)new TranslatableComponent("patchouli.gui.lexicon.progress_tooltip.secret", new Object[]{unlockedSecretEntries}).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add((Component)new TranslatableComponent("patchouli.gui.lexicon.progress_tooltip.info").m_130940_(ChatFormatting.GRAY));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(PoseStack ms, int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.m_93179_(ms, x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(PoseStack ms, FormattedCharSequence s, int x, int y, int color) {
        this.f_96547_.m_92877_(ms, s, (float)x - (float)this.f_96547_.m_92724_(s) / 2.0f, (float)y, color);
    }

    public void drawCenteredStringNoShadow(PoseStack ms, String s, int x, int y, int color) {
        this.f_96547_.m_92883_(ms, s, (float)x - (float)this.f_96547_.m_92895_(s) / 2.0f, (float)y, color);
    }

    private int getMaxAllowedScale() {
        return this.f_96541_.m_91268_().m_85385_(0, this.f_96541_.m_91390_());
    }

    public int getSpread() {
        return this.spread;
    }

    public static void drawSeparator(PoseStack ms, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(ms, book, rx, y, 140, 180, w, h);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(PoseStack ms, Book book, int x, int y) {
        GuiBook.drawFromTexture(ms, book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(PoseStack ms, Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        RenderSystem.m_69478_();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(ms, book, x, y, state.u, 197, 8, 8);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(PoseStack ms, Book book) {
        GuiBook.drawPageFiller(ms, book, 141, 18);
    }

    public static void drawPageFiller(PoseStack ms, Book book, int x, int y) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)book.fillerTexture);
        GuiBook.m_93133_((PoseStack)ms, (int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6L) {
            SoundEvent sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.BOOK_FLIP);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(Screen prevScreen, String address) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
            if (yes) {
                Util.m_137581_().m_137646_(address);
            }
            mc.m_91152_(prevScreen);
        }, address, false));
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.getContents().openLexiconGui(gui, push);
    }
}

