/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class CommandClear {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"ClearSize", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClear.remove((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ClearSize"))));
    }

    private static int remove(CommandSourceStack source, Player player, int size) {
        ServerLevel world = source.m_81372_();
        double removeSize = (float)(16 * size) / 2.0f;
        double startX = player.m_20185_() - removeSize;
        double startZ = player.m_20189_() - removeSize;
        double endX = player.m_20185_() + removeSize;
        double endZ = player.m_20189_() + removeSize;
        source.m_81354_((Component)new TranslatableComponent("commands.toolkit.remove.lagwarring"), true);
        for (int y = world.m_141937_(); y < world.m_151558_(); ++y) {
            for (double x = startX; x < endX; x += 1.0) {
                for (double z = startZ; z < endZ; z += 1.0) {
                    BlockPos tBlockPos = new BlockPos(x, (double)y, z);
                    BlockState tBlockState = world.m_8055_(tBlockPos);
                    Block tBlock = tBlockState.m_60734_();
                    if (tBlock.equals(Blocks.f_50016_) || tBlock.equals(Blocks.f_50752_) || !Objects.requireNonNull(tBlock.getRegistryName()).m_135827_().equals("minecraft") || tBlock.m_204297_().m_203656_(Tags.Blocks.ORES)) continue;
                    world.m_7731_(tBlockPos, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
        source.m_81354_((Component)new TranslatableComponent("commands.toolkit.remove.done"), true);
        return 1;
    }
}

