/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement.util;

import com.simibubi.create.content.curiosities.tools.ExtendoGripItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeMod;

@MethodsReturnNonnullByDefault
public abstract class PoleHelper<T extends Comparable<T>>
implements IPlacementHelper {
    protected final Predicate<BlockState> statePredicate;
    protected final Property<T> property;
    protected final Function<BlockState, Direction.Axis> axisFunction;

    public PoleHelper(Predicate<BlockState> statePredicate, Function<BlockState, Direction.Axis> axisFunction, Property<T> property) {
        this.statePredicate = statePredicate;
        this.axisFunction = axisFunction;
        this.property = property;
    }

    public boolean matchesAxis(BlockState state, Direction.Axis axis) {
        if (!this.statePredicate.test(state)) {
            return false;
        }
        return this.axisFunction.apply(state) == axis;
    }

    public int attachedPoles(Level world, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.m_142300_(direction);
        BlockState state = world.m_8055_(checkPos);
        int count = 0;
        while (this.matchesAxis(state, direction.m_122434_())) {
            ++count;
            checkPos = checkPos.m_142300_(direction);
            state = world.m_8055_(checkPos);
        }
        return count;
    }

    @Override
    public Predicate<BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    @Override
    public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, ray.m_82450_(), (Direction dir) -> dir.m_122434_() == this.axisFunction.apply(state));
        for (Direction dir2 : directions) {
            BlockPos newPos;
            BlockState newState;
            int poles;
            AttributeInstance reach;
            int range = (Integer)AllConfigs.SERVER.curiosities.placementAssistRange.get();
            if (player != null && (reach = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                range += 4;
            }
            if ((poles = this.attachedPoles(world, pos, dir2)) >= range || !(newState = world.m_8055_(newPos = pos.m_5484_(dir2, poles + 1))).m_60767_().m_76336_()) continue;
            return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.m_61124_(this.property, state.m_61143_(this.property)));
        }
        return PlacementOffset.fail();
    }
}

