/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.block.render.CustomBlockModels;
import com.simibubi.create.foundation.item.render.CustomItemModels;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItems;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.IEventBus;

public class ModelSwapper {
    protected CustomBlockModels customBlockModels = new CustomBlockModels();
    protected CustomItemModels customItemModels = new CustomItemModels();
    protected CustomRenderedItems customRenderedItems = new CustomRenderedItems();

    public CustomBlockModels getCustomBlockModels() {
        return this.customBlockModels;
    }

    public CustomItemModels getCustomItemModels() {
        return this.customItemModels;
    }

    public CustomRenderedItems getCustomRenderedItems() {
        return this.customRenderedItems;
    }

    public void onModelRegistry(ModelRegistryEvent event) {
        this.customRenderedItems.forEach((NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>)((NonNullBiConsumer)(item, modelFunc) -> ((CustomRenderedItemModel)((Object)((Object)modelFunc.apply(null)))).getModelLocations().forEach(ForgeModelBakery::addSpecialModel)));
    }

    public void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        this.customBlockModels.forEach((NonNullBiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>>)((NonNullBiConsumer)(block, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getAllBlockStateModelLocations(block), modelFunc)));
        this.customItemModels.forEach((NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends BakedModel>>)((NonNullBiConsumer)(item, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), modelFunc)));
        this.customRenderedItems.forEach((NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends CustomRenderedItemModel>>)((NonNullBiConsumer)(item, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), (BakedModel m) -> {
            CustomRenderedItemModel swapped = (CustomRenderedItemModel)((Object)((Object)((Object)modelFunc.apply(m))));
            swapped.loadPartials(event);
            return swapped;
        })));
    }

    public void registerListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onModelRegistry);
        modEventBus.addListener(this::onModelBake);
    }

    public static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> factory) {
        locations.forEach(location -> ModelSwapper.swapModels(modelRegistry, location, factory));
    }

    public static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        ResourceLocation blockRl = RegisteredObjects.getKeyOrThrow(block);
        block.m_49965_().m_61056_().forEach(state -> models.add(BlockModelShaper.m_110889_((ResourceLocation)blockRl, (BlockState)state)));
        return models;
    }

    public static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(RegisteredObjects.getKeyOrThrow(item), "inventory");
    }
}

