/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.linked;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LinkRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        ClientLevel world = mc.f_91073_;
        BlockHitResult result = (BlockHitResult)target;
        BlockPos pos = result.m_82425_();
        LinkBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        MutableComponent freq1 = Lang.translateDirect("logistics.firstFrequency", new Object[0]);
        MutableComponent freq2 = Lang.translateDirect("logistics.secondFrequency", new Object[0]);
        for (boolean first : Iterate.trueAndFalse) {
            AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.25);
            MutableComponent label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.m_82450_());
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ValueBox box = new ValueBox((Component)label, bb, pos).withColors(6299416, 12008493).offsetLabel(behaviour.textShift).passive(!hit);
            CreateClient.OUTLINER.showValueBox(Pair.of((Object)first, (Object)pos), box.transform(transform)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.m_82434_());
        }
    }

    public static void renderOnTileEntity(SmartTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (te == null || te.m_58901_()) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        float max = AllConfigs.CLIENT.filterItemRenderDistance.getF();
        if (!te.isVirtual() && cameraEntity != null && cameraEntity.m_20182_().m_82557_(VecHelper.getCenterOf((Vec3i)te.m_58899_())) > (double)(max * max)) {
            return;
        }
        LinkBehaviour behaviour = te.getBehaviour(LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        for (boolean first : Iterate.trueAndFalse) {
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ItemStack stack = first ? behaviour.frequencyFirst.getStack() : behaviour.frequencyLast.getStack();
            ms.m_85836_();
            transform.transform(te.m_58900_(), ms);
            ValueBoxRenderer.renderItemIntoValueBox(stack, ms, buffer, light, overlay);
            ms.m_85849_();
        }
    }
}

