/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.fluid;

import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;

public class SmartFluidTankBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<SmartFluidTankBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<SmartFluidTankBehaviour> INPUT = new BehaviourType("Input");
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT = new BehaviourType("Output");
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    protected TankSegment[] tanks;
    protected LazyOptional<? extends IFluidHandler> capability;
    protected boolean extractionAllowed = true;
    protected boolean insertionAllowed = true;
    protected Runnable fluidUpdateCallback;
    private BehaviourType<SmartFluidTankBehaviour> behaviourType;

    public static SmartFluidTankBehaviour single(SmartTileEntity te, int capacity) {
        return new SmartFluidTankBehaviour(TYPE, te, 1, capacity, false);
    }

    public SmartFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartTileEntity te, int tanks, int tankCapacity, boolean enforceVariety) {
        super(te);
        this.behaviourType = type;
        this.tanks = new TankSegment[tanks];
        IFluidHandler[] handlers = new IFluidHandler[tanks];
        for (int i = 0; i < tanks; ++i) {
            TankSegment tankSegment;
            this.tanks[i] = tankSegment = new TankSegment(tankCapacity);
            handlers[i] = tankSegment.tank;
        }
        this.capability = LazyOptional.of(() -> new InternalFluidHandler(handlers, enforceVariety));
        this.fluidUpdateCallback = () -> {};
    }

    public SmartFluidTankBehaviour whenFluidUpdates(Runnable fluidUpdateCallback) {
        this.fluidUpdateCallback = fluidUpdateCallback;
        return this;
    }

    public SmartFluidTankBehaviour allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartFluidTankBehaviour forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartFluidTankBehaviour forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.forEach(ts -> {
            ts.fluidLevel.forceNextSync();
            ts.onFluidStackChanged();
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        this.forEach(te -> {
            LerpedFloat fluidLevel = te.getFluidLevel();
            if (fluidLevel != null) {
                fluidLevel.tickChaser();
            }
        });
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.updateFluids();
    }

    public void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void updateFluids() {
        this.fluidUpdateCallback.run();
        this.tileEntity.sendData();
        this.tileEntity.m_6596_();
    }

    @Override
    public void remove() {
        super.remove();
        this.capability.invalidate();
    }

    public SmartFluidTank getPrimaryHandler() {
        return this.getPrimaryTank().tank;
    }

    public TankSegment getPrimaryTank() {
        return this.tanks[0];
    }

    public TankSegment[] getTanks() {
        return this.tanks;
    }

    public boolean isEmpty() {
        for (TankSegment tankSegment : this.tanks) {
            if (tankSegment.tank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<TankSegment> action) {
        for (TankSegment tankSegment : this.tanks) {
            action.accept(tankSegment);
        }
    }

    public LazyOptional<? extends IFluidHandler> getCapability() {
        return this.capability;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        ListTag tanksNBT = new ListTag();
        this.forEach(ts -> tanksNBT.add((Object)ts.writeNBT()));
        nbt.m_128365_(this.getType().getName() + "Tanks", (Tag)tanksNBT);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        MutableInt index = new MutableInt(0);
        NBTHelper.iterateCompoundList(nbt.m_128437_(this.getType().getName() + "Tanks", 10), c -> {
            if (index.intValue() >= this.tanks.length) {
                return;
            }
            this.tanks[index.intValue()].readNBT((CompoundTag)c, clientPacket);
            index.increment();
        });
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    public class TankSegment {
        protected SmartFluidTank tank;
        protected LerpedFloat fluidLevel;
        protected FluidStack renderedFluid;

        public TankSegment(int capacity) {
            this.tank = new SmartFluidTank(capacity, f -> this.onFluidStackChanged());
            this.fluidLevel = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
            this.renderedFluid = FluidStack.EMPTY;
        }

        public void onFluidStackChanged() {
            if (!SmartFluidTankBehaviour.this.tileEntity.m_58898_()) {
                return;
            }
            this.fluidLevel.chase((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity(), 0.25, LerpedFloat.Chaser.EXP);
            if (!SmartFluidTankBehaviour.this.getWorld().f_46443_) {
                SmartFluidTankBehaviour.this.sendDataLazily();
            }
            if (SmartFluidTankBehaviour.this.tileEntity.isVirtual() && !this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public FluidStack getRenderedFluid() {
            return this.renderedFluid;
        }

        public LerpedFloat getFluidLevel() {
            return this.fluidLevel;
        }

        public float getTotalUnits(float partialTicks) {
            return this.fluidLevel.getValue(partialTicks) * (float)this.tank.getCapacity();
        }

        public CompoundTag writeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("TankContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
            compound.m_128365_("Level", (Tag)this.fluidLevel.writeNBT());
            return compound;
        }

        public void readNBT(CompoundTag compound, boolean clientPacket) {
            this.tank.readFromNBT(compound.m_128469_("TankContent"));
            this.fluidLevel.readNBT(compound.m_128469_("Level"), clientPacket);
            if (!this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public boolean isEmpty(float partialTicks) {
            FluidStack renderedFluid = this.getRenderedFluid();
            if (renderedFluid.isEmpty()) {
                return true;
            }
            float units = this.getTotalUnits(partialTicks);
            return units < 1.0f;
        }
    }

    public class InternalFluidHandler
    extends CombinedTankWrapper {
        public InternalFluidHandler(IFluidHandler[] handlers, boolean enforceVariety) {
            super(handlers);
            if (enforceVariety) {
                this.enforceVariety();
            }
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!SmartFluidTankBehaviour.this.insertionAllowed) {
                return 0;
            }
            return super.fill(resource, action);
        }

        public int forceFill(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!SmartFluidTankBehaviour.this.extractionAllowed) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!SmartFluidTankBehaviour.this.extractionAllowed) {
                return FluidStack.EMPTY;
            }
            return super.drain(maxDrain, action);
        }
    }
}

