/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DynamicDataProvider<T>
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String name;
    private final RegistryAccess registryAccess;
    private final RegistryAccess.RegistryData<T> registryData;
    private final Map<ResourceLocation, T> values;

    public DynamicDataProvider(DataGenerator generator, String name, RegistryAccess registryAccess, RegistryAccess.RegistryData<T> registryData, Map<ResourceLocation, T> values) {
        this.generator = generator;
        this.name = name;
        this.registryAccess = registryAccess;
        this.registryData = registryData;
        this.values = values;
    }

    @Nullable
    public static <T> DynamicDataProvider<T> create(DataGenerator generator, String name, RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey, Map<ResourceLocation, T> values) {
        RegistryAccess.RegistryData registryData = (RegistryAccess.RegistryData)RegistryAccess.f_123048_.get(registryKey);
        if (registryData == null) {
            return null;
        }
        return new DynamicDataProvider<T>(generator, name, registryAccess, registryData, values);
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess);
        this.dumpValues(path, cache, (DynamicOps<JsonElement>)ops, (ResourceKey<? extends Registry<T>>)this.registryData.f_123101_(), this.values, (Encoder<T>)this.registryData.f_123102_());
    }

    private void dumpValues(Path rootPath, HashCache cache, DynamicOps<JsonElement> ops, ResourceKey<? extends Registry<T>> registryKey, Map<ResourceLocation, T> values, Encoder<T> encoder) {
        for (Map.Entry<ResourceLocation, T> entry : values.entrySet()) {
            Path path = this.createPath(rootPath, registryKey.m_135782_(), entry.getKey());
            this.dumpValue(path, cache, ops, encoder, entry.getValue());
        }
    }

    private void dumpValue(Path path, HashCache cache, DynamicOps<JsonElement> ops, Encoder<T> encoder, T value) {
        try {
            Optional optional = encoder.encodeStart(ops, value).resultOrPartial(message -> Create.LOGGER.error("Couldn't serialize element {}: {}", (Object)path, message));
            if (optional.isPresent()) {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
            }
        }
        catch (IOException e) {
            Create.LOGGER.error("Couldn't save element {}", (Object)path, (Object)e);
        }
    }

    private Path createPath(Path path, ResourceLocation registry, ResourceLocation value) {
        return path.resolve("data").resolve(value.m_135827_()).resolve(registry.m_135815_()).resolve(value.m_135815_() + ".json");
    }

    public String m_6055_() {
        return this.name;
    }
}

