/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;

public final class QuadHelper {
    public static final VertexFormat FORMAT = DefaultVertexFormat.f_85811_;
    public static final int VERTEX_STRIDE = FORMAT.m_86017_();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 1;
    public static final int Z_OFFSET = 2;
    public static final int COLOR_OFFSET = 3;
    public static final int U_OFFSET = 4;
    public static final int V_OFFSET = 5;
    public static final int LIGHT_OFFSET = 6;
    public static final int NORMAL_OFFSET = 7;

    private QuadHelper() {
    }

    public static BakedQuad clone(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static float getU(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 4]);
    }

    public static float getV(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 5]);
    }

    public static void setU(int[] vertexData, int vertex, float u) {
        vertexData[vertex * QuadHelper.VERTEX_STRIDE + 4] = Float.floatToRawIntBits(u);
    }

    public static void setV(int[] vertexData, int vertex, float v) {
        vertexData[vertex * QuadHelper.VERTEX_STRIDE + 5] = Float.floatToRawIntBits(v);
    }
}

