/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicChunkSource;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.registries.ForgeRegistries;

public class SchematicWorld
extends WrappedWorld
implements ServerLevelAccessor {
    protected Map<BlockPos, BlockState> blocks;
    protected Map<BlockPos, BlockEntity> tileEntities;
    protected List<BlockEntity> renderedTileEntities;
    protected List<Entity> entities;
    protected BoundingBox bounds;
    public BlockPos anchor;
    public boolean renderMode;

    public SchematicWorld(Level original) {
        this(BlockPos.f_121853_, original);
    }

    public SchematicWorld(BlockPos anchor, Level original) {
        super(original);
        this.setChunkSource(new SchematicChunkSource(this));
        this.blocks = new HashMap<BlockPos, BlockState>();
        this.tileEntities = new HashMap<BlockPos, BlockEntity>();
        this.bounds = new BoundingBox(BlockPos.f_121853_);
        this.anchor = anchor;
        this.entities = new ArrayList<Entity>();
        this.renderedTileEntities = new ArrayList<BlockEntity>();
    }

    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    @Override
    public boolean m_7967_(Entity entityIn) {
        if (entityIn instanceof ItemFrame) {
            ((ItemFrame)entityIn).m_31822_().m_41751_(null);
        }
        if (entityIn instanceof ArmorStand) {
            ArmorStand armorStandEntity = (ArmorStand)entityIn;
            armorStandEntity.m_20158_().forEach(stack -> stack.m_41751_(null));
        }
        return this.entities.add(entityIn);
    }

    public Stream<Entity> getEntityStream() {
        return this.entities.stream();
    }

    @Override
    public BlockEntity m_7702_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return null;
        }
        if (this.tileEntities.containsKey(pos)) {
            return this.tileEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.m_141950_((Vec3i)this.anchor))) {
            return null;
        }
        BlockState blockState = this.m_8055_(pos);
        if (blockState.m_155947_()) {
            try {
                BlockEntity tileEntity = ((EntityBlock)blockState.m_60734_()).m_142194_(pos, blockState);
                if (tileEntity != null) {
                    this.onTEadded(tileEntity, pos);
                    this.tileEntities.put(pos, tileEntity);
                    this.renderedTileEntities.add(tileEntity);
                }
                return tileEntity;
            }
            catch (Exception e) {
                Create.LOGGER.debug("Could not create TE of block " + blockState, (Throwable)e);
            }
        }
        return null;
    }

    protected void onTEadded(BlockEntity tileEntity, BlockPos pos) {
        tileEntity.m_142339_((Level)this);
    }

    @Override
    public BlockState m_8055_(BlockPos globalPos) {
        BlockPos pos = globalPos.m_141950_((Vec3i)this.anchor);
        if (pos.m_123342_() - this.bounds.m_162396_() == -1 && !this.renderMode) {
            return Blocks.f_50440_.m_49966_();
        }
        if (this.getBounds().m_71051_((Vec3i)pos) && this.blocks.containsKey(pos)) {
            return this.processBlockStateForPrinting(this.blocks.get(pos));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return ForgeRegistries.BIOMES.getHolder(Biomes.f_48202_.m_135782_()).orElse(null);
    }

    public int m_45517_(LightLayer lightLayer, BlockPos pos) {
        return 15;
    }

    @Override
    public float m_7717_(Direction face, boolean hasShade) {
        return 1.0f;
    }

    @Override
    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    @Override
    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public List<Entity> m_6249_(Entity arg0, AABB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> m_6443_(Class<T> arg0, AABB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public int m_7445_() {
        return 0;
    }

    @Override
    public boolean m_7433_(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.m_8055_(pos));
    }

    public boolean m_46961_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    public boolean m_7471_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    public boolean m_7731_(BlockPos pos, BlockState arg1, int arg2) {
        BlockEntity tileEntity;
        pos = pos.m_7949_().m_141950_((Vec3i)this.anchor);
        this.bounds = BBHelper.encapsulate(this.bounds, pos);
        this.blocks.put(pos, arg1);
        if (this.tileEntities.containsKey(pos) && !(tileEntity = this.tileEntities.get(pos)).m_58903_().m_155262_(arg1)) {
            this.tileEntities.remove(pos);
            this.renderedTileEntities.remove(tileEntity);
        }
        if ((tileEntity = this.m_7702_(pos)) != null) {
            this.tileEntities.put(pos, tileEntity);
        }
        return true;
    }

    @Override
    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public Iterable<BlockEntity> getRenderedTileEntities() {
        return this.renderedTileEntities;
    }

    protected BlockState processBlockStateForPrinting(BlockState state) {
        if (state.m_60734_() instanceof AbstractFurnaceBlock && state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ServerLevel m_6018_() {
        if (this.world instanceof ServerLevel) {
            return (ServerLevel)this.world;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

