/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule;

import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleContainer;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ScheduleItem
extends Item
implements MenuProvider {
    public ScheduleItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!world.f_46443_ && player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.m_130055_(heldItem));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        InteractionResult pass = InteractionResult.PASS;
        Schedule schedule = ScheduleItem.getSchedule(pStack);
        if (schedule == null) {
            return pass;
        }
        if (pInteractionTarget == null) {
            return pass;
        }
        Entity rootVehicle = pInteractionTarget.m_20201_();
        if (!(rootVehicle instanceof CarriageContraptionEntity)) {
            return pass;
        }
        if (pPlayer.f_19853_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        CarriageContraptionEntity entity = (CarriageContraptionEntity)rootVehicle;
        Contraption contraption = entity.getContraption();
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            Train train = entity.getCarriage().train;
            if (train == null) {
                return InteractionResult.SUCCESS;
            }
            Integer seatIndex = contraption.getSeatMapping().get(pInteractionTarget.m_142081_());
            if (seatIndex == null) {
                return InteractionResult.SUCCESS;
            }
            BlockPos seatPos = contraption.getSeats().get(seatIndex);
            Couple<Boolean> directions = cc.conductorSeats.get(seatPos);
            if (directions == null) {
                pPlayer.m_5661_((Component)Lang.translateDirect("schedule.non_controlling_seat", new Object[0]), true);
                AllSoundEvents.DENY.playOnServer(pPlayer.f_19853_, (Vec3i)pPlayer.m_142538_(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (train.runtime.getSchedule() != null) {
                AllSoundEvents.DENY.playOnServer(pPlayer.f_19853_, (Vec3i)pPlayer.m_142538_(), 1.0f, 1.0f);
                pPlayer.m_5661_((Component)Lang.translateDirect("schedule.remove_with_empty_hand", new Object[0]), true);
                return InteractionResult.SUCCESS;
            }
            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(pPlayer.f_19853_, (Vec3i)pPlayer.m_142538_(), 1.0f, 1.0f);
                pPlayer.m_5661_((Component)Lang.translateDirect("schedule.no_stops", new Object[0]), true);
                return InteractionResult.SUCCESS;
            }
            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.awardTo(pPlayer);
            AllSoundEvents.CONFIRM.playOnServer(pPlayer.f_19853_, (Vec3i)pPlayer.m_142538_(), 1.0f, 1.0f);
            pPlayer.m_5661_((Component)Lang.translateDirect("schedule.applied_to_train", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
            pStack.m_41774_(1);
            pPlayer.m_21008_(pUsedHand, pStack.m_41619_() ? ItemStack.f_41583_ : pStack);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Schedule schedule = ScheduleItem.getSchedule(stack);
        if (schedule == null || schedule.entries.isEmpty()) {
            return;
        }
        MutableComponent caret = Components.literal("> ").m_130940_(ChatFormatting.GRAY);
        MutableComponent arrow = Components.literal("-> ").m_130940_(ChatFormatting.GRAY);
        List<ScheduleEntry> entries = schedule.entries;
        for (int i = 0; i < entries.size(); ++i) {
            boolean current = i == schedule.savedProgress && schedule.entries.size() > 1;
            ScheduleEntry entry = entries.get(i);
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (!(scheduleInstruction instanceof DestinationInstruction)) continue;
            DestinationInstruction destination = (DestinationInstruction)scheduleInstruction;
            ChatFormatting format = current ? ChatFormatting.YELLOW : ChatFormatting.GOLD;
            MutableComponent prefix = current ? arrow : caret;
            tooltip.add((Component)prefix.m_6881_().m_7220_((Component)Components.literal(destination.getFilter()).m_130940_(format)));
        }
    }

    public static Schedule getSchedule(ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return null;
        }
        if (!pStack.m_41783_().m_128441_("Schedule")) {
            return null;
        }
        return Schedule.fromTag(pStack.m_41737_("Schedule"));
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        ItemStack heldItem = player.m_21205_();
        return new ScheduleContainer((MenuType)AllContainerTypes.SCHEDULE.get(), id, inv, heldItem);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
    }
}

