/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.depot.DepotRenderer;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StationRenderer
extends SafeTileEntityRenderer<StationTileEntity> {
    public StationRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(StationTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockPos pos = te.m_58899_();
        TrackTargetingBehaviour<GlobalStation> target = te.edgePoint;
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = te.m_58904_();
        DepotRenderer.renderItemsOf(te, partialTicks, ms, buffer, light, overlay, te.depotBehaviour);
        BlockState trackState = level.m_8055_(targetPosition);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        GlobalStation station = te.getStation();
        boolean isAssembling = (Boolean)te.m_58900_().m_61143_((Property)StationBlock.ASSEMBLING);
        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !te.isVirtual()) {
            StationRenderer.renderFlag(te.flag.getValue(partialTicks) > 0.75f ? AllBlockPartials.STATION_ON : AllBlockPartials.STATION_OFF, te, partialTicks, ms, buffer, light, overlay);
            ms.m_85836_();
            ms.m_85837_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
            TrackTargetingBehaviour.render((LevelAccessor)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, TrackTargetingBehaviour.RenderedTrackOverlayType.STATION, 1.0f);
            ms.m_85849_();
            return;
        }
        StationRenderer.renderFlag(AllBlockPartials.STATION_ASSEMBLE, te, partialTicks, ms, buffer, light, overlay);
        ITrackBlock track = (ITrackBlock)block;
        Direction direction = te.assemblyDirection;
        if (te.isVirtual() && te.bogeyLocations == null) {
            te.refreshAssemblyInfo();
        }
        if (direction == null || te.assemblyLength == 0 || te.bogeyLocations == null) {
            return;
        }
        ms.m_85836_();
        BlockPos offset = targetPosition.m_141950_((Vec3i)pos);
        ms.m_85837_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        BlockPos.MutableBlockPos currentPos = targetPosition.m_122032_();
        PartialModel assemblyOverlay = track.prepareAssemblyOverlay((BlockGetter)level, targetPosition, trackState, direction, ms);
        int colorWhenValid = 9876991;
        int colorWhenCarriage = 13303702;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110457_());
        currentPos.m_122175_(direction, 1);
        ms.m_85837_(0.0, 0.0, 1.0);
        for (int i = 0; i < te.assemblyLength; ++i) {
            int valid = te.isValidBogeyOffset(i) ? colorWhenValid : -1;
            for (int j : te.bogeyLocations) {
                if (i != j) continue;
                valid = colorWhenCarriage;
                break;
            }
            if (valid != -1) {
                int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)currentPos);
                SuperByteBuffer sbb = CachedBufferer.partial(assemblyOverlay, trackState);
                sbb.color(valid);
                sbb.light(lightColor);
                sbb.renderInto(ms, vb);
            }
            ms.m_85837_(0.0, 0.0, 1.0);
            currentPos.m_122173_(direction);
        }
        ms.m_85849_();
    }

    public static void renderFlag(PartialModel flag, StationTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!te.resolveFlagAngle()) {
            return;
        }
        SuperByteBuffer flagBB = CachedBufferer.partial(flag, te.m_58900_());
        StationRenderer.transformFlag(flagBB, te, partialTicks, te.flagYRot, te.flagFlipped);
        ((SuperByteBuffer)flagBB.translate(0.03125, 0.0, 0.0).rotateY(te.flagFlipped ? 0.0 : 180.0)).translate(-0.03125, 0.0, 0.0).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    public static void transformFlag(Transform<?> flag, StationTileEntity te, float partialTicks, int yRot, boolean flipped) {
        float value = te.flag.getValue(partialTicks);
        float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
        if (te.flag.getChaseTarget() > 0.0f && !te.flag.settled() && progress == 1.0f) {
            float wiggleProgress = (value - 0.2f) / 0.8f;
            progress = (float)((double)progress + Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
        }
        float nudge = 0.001953125f;
        ((Transform)((Transform)((Transform)((Transform)flag.centre()).rotateY((double)yRot)).translate((double)nudge, 0.59375, flipped ? (double)(0.875f - nudge) : (double)(0.125f + nudge))).unCentre()).rotateX((double)((float)(flipped ? 1 : -1) * (progress * 90.0f + 270.0f)));
    }

    public boolean shouldRenderOffScreen(StationTileEntity pBlockEntity) {
        return true;
    }

    public int m_142163_() {
        return 192;
    }
}

