/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TrackEdge {
    public TrackNode node1;
    public TrackNode node2;
    BezierConnection turn;
    EdgeData edgeData;
    boolean interDimensional;

    public TrackEdge(TrackNode node1, TrackNode node2, BezierConnection turn) {
        this.interDimensional = !node1.location.dimension.equals(node2.location.dimension);
        this.edgeData = new EdgeData(this);
        this.node1 = node1;
        this.node2 = node2;
        this.turn = turn;
    }

    public boolean isTurn() {
        return this.turn != null;
    }

    public boolean isInterDimensional() {
        return this.interDimensional;
    }

    public EdgeData getEdgeData() {
        return this.edgeData;
    }

    public BezierConnection getTurn() {
        return this.turn;
    }

    public Vec3 getDirection(boolean fromFirst) {
        return this.getPosition(fromFirst ? 0.25 : 1.0).m_82546_(this.getPosition(fromFirst ? 0.0 : 0.75)).m_82541_();
    }

    public Vec3 getDirectionAt(double t) {
        double length = this.getLength();
        double step = 0.5 / length;
        Vec3 ahead = this.getPosition(Math.min(1.0, (t /= length) + step));
        Vec3 behind = this.getPosition(Math.max(0.0, t - step));
        return ahead.m_82546_(behind).m_82541_();
    }

    public boolean canTravelTo(TrackEdge other) {
        if (this.isInterDimensional() || other.isInterDimensional()) {
            return true;
        }
        Vec3 newDirection = other.getDirection(true);
        return this.getDirection(false).m_82526_(newDirection) > 0.875;
    }

    public double getLength() {
        return this.isInterDimensional() ? 0.0 : (this.isTurn() ? this.turn.getLength() : this.node1.location.getLocation().m_82554_(this.node2.location.getLocation()));
    }

    public double incrementT(double currentT, double distance) {
        boolean tooFar = Math.abs(distance) > 5.0;
        double length = this.getLength();
        return !tooFar && this.isTurn() ? this.turn.incrementT(currentT, distance) : currentT + (distance /= length == 0.0 ? 1.0 : length);
    }

    public Vec3 getPosition(double t) {
        return this.isTurn() ? this.turn.getPosition(Mth.m_14008_((double)t, (double)0.0, (double)1.0)) : VecHelper.lerp((float)t, this.node1.location.getLocation(), this.node2.location.getLocation());
    }

    /*
     * Exception decompiling
     */
    public Collection<double[]> getIntersection(TrackNode node1, TrackNode node2, TrackEdge other, TrackNode other1, TrackNode other2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Vec3 getNormal(TrackNode node1, TrackNode node2, double t) {
        return this.isTurn() ? this.turn.getNormal(Mth.m_14008_((double)t, (double)0.0, (double)1.0)) : node1.getNormal();
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag baseCompound = this.isTurn() ? this.turn.write(BlockPos.f_121853_) : new CompoundTag();
        baseCompound.m_128365_("Signals", (Tag)this.edgeData.write(dimensions));
        return baseCompound;
    }

    public static TrackEdge read(TrackNode node1, TrackNode node2, CompoundTag tag, TrackGraph graph, DimensionPalette dimensions) {
        TrackEdge trackEdge = new TrackEdge(node1, node2, tag.m_128441_("Positions") ? new BezierConnection(tag, BlockPos.f_121853_) : null);
        trackEdge.edgeData = EdgeData.read(tag.m_128469_("Signals"), trackEdge, graph, dimensions);
        return trackEdge;
    }
}

