/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.diodes.BrassDiodeBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RoseQuartzLampBlock
extends Block
implements IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty POWERING = BrassDiodeBlock.POWERING;
    public static final BooleanProperty ACTIVATE = BooleanProperty.m_61465_((String)"activate");

    public RoseQuartzLampBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVATE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        return (BlockState)stateForPlacement.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_46753_(pContext.m_8083_())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{POWERED, POWERING, ACTIVATE}));
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return false;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean isPowered = (Boolean)pState.m_61143_((Property)POWERED);
        if (isPowered == pLevel.m_46753_(pPos)) {
            return;
        }
        if (isPowered) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
            return;
        }
        this.forEachInCluster(pLevel, pPos, (currentPos, currentState) -> {
            pLevel.m_7731_(currentPos, (BlockState)currentState.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false)), 2);
            this.scheduleActivation(pLevel, (BlockPos)currentPos);
        });
        pLevel.m_7731_(pPos, (BlockState)((BlockState)((BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ACTIVATE, (Comparable)Boolean.valueOf(true)), 2);
        pLevel.m_46672_(pPos, (Block)this);
        this.scheduleActivation(pLevel, pPos);
    }

    private void scheduleActivation(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_183326_().m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    private void forEachInCluster(Level pLevel, BlockPos pPos, BiConsumer<BlockPos, BlockState> callback) {
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(pPos);
        visited.add(pPos);
        while (!frontier.isEmpty()) {
            BlockPos pos = (BlockPos)frontier.remove(0);
            for (Direction d : Iterate.directions) {
                BlockState currentState;
                BlockPos currentPos = pos.m_142300_(d);
                if (currentPos.m_123333_((Vec3i)pPos) > 16 || !visited.add(currentPos) || !(currentState = pLevel.m_8055_(currentPos)).m_60713_((Block)this)) continue;
                callback.accept(currentPos, currentState);
                frontier.add(currentPos);
            }
        }
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == null) {
            return 0;
        }
        BlockState toState = pLevel.m_8055_(pPos.m_142300_(pDirection.m_122424_()));
        if (toState.m_60713_((Block)this)) {
            return 0;
        }
        if (toState.m_60713_(Blocks.f_50328_)) {
            return this.getDistanceToPowered(pLevel, pPos, pDirection);
        }
        return (Boolean)pState.m_61143_((Property)POWERING) != false ? 15 : 0;
    }

    private int getDistanceToPowered(BlockGetter level, BlockPos pos, Direction column) {
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        for (int power = 15; power > 0; --power) {
            BlockState blockState = level.m_8055_((BlockPos)currentPos);
            if (!blockState.m_60713_((Block)this)) {
                return 0;
            }
            if (((Boolean)blockState.m_61143_((Property)POWERING)).booleanValue()) {
                return power;
            }
            currentPos.m_122173_(column);
        }
        return 0;
    }

    public void m_7458_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        boolean wasPowering = (Boolean)pState.m_61143_((Property)POWERING);
        boolean shouldBePowering = (Boolean)pState.m_61143_((Property)ACTIVATE);
        if (wasPowering || shouldBePowering) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)ACTIVATE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(shouldBePowering)), 2);
        }
        pLevel.m_46672_(pPos, (Block)this);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return InteractionResult.PASS;
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61122_((Property)POWERING);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = IWrenchable.super.onWrenched(state, context);
        if (!onWrenched.m_19077_()) {
            return onWrenched;
        }
        this.forEachInCluster(context.m_43725_(), context.m_8083_(), (currentPos, currentState) -> context.m_43725_().m_46672_(currentPos, (Block)this));
        return onWrenched;
    }
}

