/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.content.logistics.block.chute.SmartChuteBlock;
import com.simibubi.create.content.logistics.block.chute.SmartChuteFilterSlotPositioning;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SmartChuteTileEntity
extends ChuteTileEntity {
    FilteringBehaviour filtering;

    public SmartChuteTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected boolean canAcceptItem(ItemStack stack) {
        return super.canAcceptItem(stack) && this.canCollectItemsFromBelow() && this.filtering.test(stack);
    }

    @Override
    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    @Override
    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    @Override
    protected boolean canCollectItemsFromBelow() {
        BlockState blockState = this.m_58900_();
        return blockState.m_61138_((Property)SmartChuteBlock.POWERED) && (Boolean)blockState.m_61143_((Property)SmartChuteBlock.POWERED) == false;
    }

    @Override
    protected boolean canOutputItems() {
        BlockState blockState = this.m_58900_();
        return blockState.m_61138_((Property)SmartChuteBlock.POWERED) && (Boolean)blockState.m_61143_((Property)SmartChuteBlock.POWERED) == false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new SmartChuteFilterSlotPositioning()).showCountWhen(this::isExtracting);
        behaviours.add(this.filtering);
        super.addBehaviours(behaviours);
    }

    private boolean isExtracting() {
        boolean up = this.getItemMotion() < 0.0f;
        BlockPos chutePos = this.f_58858_.m_142300_(up ? Direction.UP : Direction.DOWN);
        BlockState blockState = this.f_58857_.m_8055_(chutePos);
        return !AbstractChuteBlock.isChute(blockState) && !blockState.m_60767_().m_76336_();
    }
}

