/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class SandPaperPolishingRecipe
extends ProcessingRecipe<SandPaperInv> {
    public SandPaperPolishingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.SANDPAPER_POLISHING, params);
    }

    public boolean matches(SandPaperInv inv, Level worldIn) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    @Override
    protected int getMaxInputCount() {
        return 1;
    }

    @Override
    protected int getMaxOutputCount() {
        return 1;
    }

    public static boolean canPolish(Level world, ItemStack stack) {
        return !SandPaperPolishingRecipe.getMatchingRecipes(world, stack).isEmpty();
    }

    public static ItemStack applyPolish(Level world, Vec3 position, ItemStack stack, ItemStack sandPaperStack) {
        List<Recipe<SandPaperInv>> matchingRecipes = SandPaperPolishingRecipe.getMatchingRecipes(world, stack);
        if (!matchingRecipes.isEmpty()) {
            return matchingRecipes.get(0).m_5874_((Container)new SandPaperInv(stack)).m_41777_();
        }
        return stack;
    }

    public static List<Recipe<SandPaperInv>> getMatchingRecipes(Level world, ItemStack stack) {
        return world.m_7465_().m_44056_(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (Container)new SandPaperInv(stack), world);
    }

    public static class SandPaperInv
    extends RecipeWrapper {
        public SandPaperInv(ItemStack stack) {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
            this.inv.setStackInSlot(0, stack);
        }
    }
}

