/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.deco;

import com.simibubi.create.content.curiosities.deco.SlidingDoorBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SlidingDoorTileEntity
extends SmartTileEntity {
    LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;

    public SlidingDoorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.animation = LerpedFloat.linear().startWithValue(SlidingDoorTileEntity.isOpen(state) ? 1.0 : 0.0);
    }

    @Override
    public void tick() {
        if (this.deferUpdate && !this.f_58857_.m_5776_()) {
            this.deferUpdate = false;
            BlockState blockState = this.m_58900_();
            blockState.m_60690_(this.f_58857_, this.f_58858_, Blocks.f_50016_, this.f_58858_, false);
        }
        super.tick();
        boolean open = SlidingDoorTileEntity.isOpen(this.m_58900_());
        boolean wasSettled = this.animation.settled();
        this.animation.chase(open ? 1.0 : 0.0, 0.15f, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.f_58857_.m_5776_()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open && this.isVisible(this.m_58900_())) {
                --this.bridgeTicks;
            }
            return;
        }
        if (!open && !wasSettled && this.animation.settled() && !this.isVisible(this.m_58900_())) {
            this.showBlockModel();
        }
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(1.0);
    }

    protected boolean isVisible(BlockState state) {
        return state.m_61145_((Property)SlidingDoorBlock.VISIBLE).orElse(true);
    }

    protected boolean shouldRenderSpecial(BlockState state) {
        return !this.isVisible(state) || this.bridgeTicks != 0;
    }

    protected void showBlockModel() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(true)), 3);
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public static boolean isOpen(BlockState state) {
        return state.m_61145_((Property)DoorBlock.f_52727_).orElse(false);
    }
}

