/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.SmartFluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class SmartFluidPipeTileEntity
extends SmartTileEntity {
    private FilteringBehaviour filter;

    public SmartFluidPipeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new SmartPipeBehaviour(this));
        this.filter = new FilteringBehaviour(this, new SmartPipeFilterSlot()).forFluids().withCallback(this::onFilterChanged);
        behaviours.add(this.filter);
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, this.f_58858_, this.m_58900_());
    }

    class SmartPipeBehaviour
    extends StraightPipeTileEntity.StraightPipeFluidTransportBehaviour {
        public SmartPipeBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (fluid.isEmpty() || SmartFluidPipeTileEntity.this.filter != null && SmartFluidPipeTileEntity.this.filter.test(fluid)) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return state.m_60734_() instanceof SmartFluidPipeBlock && SmartFluidPipeBlock.getPipeAxis(state) == direction.m_122434_();
        }
    }

    class SmartPipeFilterSlot
    extends ValueBoxTransform {
        SmartPipeFilterSlot() {
        }

        @Override
        protected Vec3 getLocalOffset(BlockState state) {
            float y;
            AttachFace face = (AttachFace)state.m_61143_((Property)SmartFluidPipeBlock.f_53179_);
            float f = face == AttachFace.CEILING ? 0.3f : (y = face == AttachFace.WALL ? 11.3f : 15.3f);
            float z = face == AttachFace.CEILING ? 4.6f : (face == AttachFace.WALL ? 0.6f : 4.6f);
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, y, z), this.angleY(state), Direction.Axis.Y);
        }

        @Override
        protected void rotate(BlockState state, PoseStack ms) {
            AttachFace face = (AttachFace)state.m_61143_((Property)SmartFluidPipeBlock.f_53179_);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)this.angleY(state))).rotateX(face == AttachFace.CEILING ? -45.0 : 45.0);
        }

        protected float angleY(BlockState state) {
            AttachFace face = (AttachFace)state.m_61143_((Property)SmartFluidPipeBlock.f_53179_);
            float horizontalAngle = AngleHelper.horizontalAngle((Direction)state.m_61143_((Property)SmartFluidPipeBlock.f_54117_));
            if (face == AttachFace.WALL) {
                horizontalAngle += 180.0f;
            }
            return horizontalAngle;
        }
    }
}

