/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.content.contraptions.components.actors.PortableFluidInterfaceTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidNetwork {
    private static int CYCLES_PER_TICK = 16;
    Level world;
    BlockFace start;
    Supplier<LazyOptional<IFluidHandler>> sourceSupplier;
    LazyOptional<IFluidHandler> source;
    int transferSpeed;
    int pauseBeforePropagation;
    List<BlockFace> queued;
    Set<Pair<BlockFace, PipeConnection>> frontier;
    Set<BlockPos> visited;
    FluidStack fluid;
    List<Pair<BlockFace, LazyOptional<IFluidHandler>>> targets;
    Map<BlockPos, WeakReference<FluidTransportBehaviour>> cache;

    public FluidNetwork(Level world, BlockFace location, Supplier<LazyOptional<IFluidHandler>> sourceSupplier) {
        this.world = world;
        this.start = location;
        this.sourceSupplier = sourceSupplier;
        this.source = LazyOptional.empty();
        this.fluid = FluidStack.EMPTY;
        this.frontier = new HashSet<Pair<BlockFace, PipeConnection>>();
        this.visited = new HashSet<BlockPos>();
        this.targets = new ArrayList<Pair<BlockFace, LazyOptional<IFluidHandler>>>();
        this.cache = new HashMap<BlockPos, WeakReference<FluidTransportBehaviour>>();
        this.queued = new ArrayList<BlockFace>();
        this.reset();
    }

    public void tick() {
        if (this.pauseBeforePropagation > 0) {
            --this.pauseBeforePropagation;
            return;
        }
        for (int cycle = 0; cycle < CYCLES_PER_TICK; ++cycle) {
            boolean shouldContinue = false;
            Iterator<Pair> iterator = this.queued.iterator();
            while (iterator.hasNext()) {
                BlockFace blockFace = iterator.next();
                if (!this.isPresent(blockFace)) continue;
                PipeConnection pipeConnection = this.get(blockFace);
                if (pipeConnection != null) {
                    if (blockFace.equals(this.start)) {
                        this.transferSpeed = (int)Math.max(1.0f, pipeConnection.pressure.get(true).floatValue() / 2.0f);
                    }
                    this.frontier.add(Pair.of(blockFace, pipeConnection));
                }
                iterator.remove();
            }
            iterator = this.frontier.iterator();
            while (iterator.hasNext()) {
                Pair pair = iterator.next();
                BlockFace blockFace = (BlockFace)pair.getFirst();
                PipeConnection pipeConnection = (PipeConnection)pair.getSecond();
                if (!pipeConnection.hasFlow()) continue;
                PipeConnection.Flow flow = pipeConnection.flow.get();
                if (!this.fluid.isEmpty() && !flow.fluid.isFluidEqual(this.fluid)) {
                    iterator.remove();
                    continue;
                }
                if (!flow.inbound) {
                    if (!(pipeConnection.comparePressure() >= 0.0f)) continue;
                    iterator.remove();
                    continue;
                }
                if (!flow.complete) continue;
                if (this.fluid.isEmpty()) {
                    this.fluid = flow.fluid;
                }
                boolean canRemove = true;
                for (Direction side : Iterate.directions) {
                    BlockFace adjacentLocation;
                    PipeConnection adjacent;
                    if (side == blockFace.getFace() || (adjacent = this.get(adjacentLocation = new BlockFace(blockFace.getPos(), side))) == null) continue;
                    if (!adjacent.hasFlow()) {
                        if (!adjacent.hasPressure() || !(((Float)adjacent.pressure.getSecond()).floatValue() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    PipeConnection.Flow outFlow = adjacent.flow.get();
                    if (outFlow.inbound) {
                        if (!(adjacent.comparePressure() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    if (!outFlow.complete) {
                        canRemove = false;
                        continue;
                    }
                    if (!adjacent.source.isPresent() && !adjacent.determineSource(this.world, blockFace.getPos())) {
                        canRemove = false;
                        continue;
                    }
                    if (adjacent.source.isPresent() && adjacent.source.get().isEndpoint()) {
                        this.targets.add(Pair.of(adjacentLocation, adjacent.source.get().provideHandler()));
                        continue;
                    }
                    if (!this.visited.add(adjacentLocation.getConnectedPos())) continue;
                    this.queued.add(adjacentLocation.getOpposite());
                    shouldContinue = true;
                }
                if (!canRemove) continue;
                iterator.remove();
            }
            if (!shouldContinue) break;
        }
        if (!this.source.isPresent()) {
            this.source = this.sourceSupplier.get();
        }
        if (!this.source.isPresent()) {
            return;
        }
        this.keepPortableFluidInterfaceEngaged();
        if (this.targets.isEmpty()) {
            return;
        }
        for (Pair<BlockFace, LazyOptional<IFluidHandler>> pair : this.targets) {
            PipeConnection pipeConnection;
            if (pair.getSecond().isPresent() && this.world.m_46467_() % 40L != 0L || (pipeConnection = this.get(pair.getFirst())) == null) continue;
            pipeConnection.source.ifPresent(fs -> {
                if (fs.isEndpoint()) {
                    pair.setSecond(fs.provideHandler());
                }
            });
        }
        int flowSpeed = this.transferSpeed;
        for (boolean simulate : Iterate.trueAndFalse) {
            FluidStack genericExtract;
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            IFluidHandler handler = (IFluidHandler)this.source.orElse(null);
            if (handler == null) {
                return;
            }
            FluidStack transfer = FluidStack.EMPTY;
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contained = handler.getFluidInTank(i);
                if (contained.isEmpty() || !contained.isFluidEqual(this.fluid)) continue;
                FluidStack toExtract = FluidHelper.copyStackWithAmount(contained, flowSpeed);
                transfer = handler.drain(toExtract, action);
            }
            if (transfer.isEmpty() && !(genericExtract = handler.drain(flowSpeed, action)).isEmpty() && genericExtract.isFluidEqual(this.fluid)) {
                transfer = genericExtract;
            }
            if (transfer.isEmpty()) {
                return;
            }
            if (simulate) {
                flowSpeed = transfer.getAmount();
            }
            ArrayList<Pair<BlockFace, LazyOptional<IFluidHandler>>> availableOutputs = new ArrayList<Pair<BlockFace, LazyOptional<IFluidHandler>>>(this.targets);
            block7: while (!availableOutputs.isEmpty() && transfer.getAmount() > 0) {
                int dividedTransfer = transfer.getAmount() / availableOutputs.size();
                int remainder = transfer.getAmount() % availableOutputs.size();
                Iterator iterator = availableOutputs.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    int toTransfer = dividedTransfer;
                    if (remainder > 0) {
                        ++toTransfer;
                        --remainder;
                    }
                    if (transfer.isEmpty()) continue block7;
                    IFluidHandler targetHandler = (IFluidHandler)((LazyOptional)pair.getSecond()).orElse(null);
                    if (targetHandler == null) {
                        iterator.remove();
                        continue;
                    }
                    FluidStack divided = transfer.copy();
                    divided.setAmount(toTransfer);
                    int fill = targetHandler.fill(divided, action);
                    transfer.setAmount(transfer.getAmount() - fill);
                    if (fill >= toTransfer) continue;
                    iterator.remove();
                }
            }
            flowSpeed -= transfer.getAmount();
            transfer = FluidStack.EMPTY;
        }
    }

    private void keepPortableFluidInterfaceEngaged() {
        IFluidHandler handler = (IFluidHandler)this.source.orElse(null);
        if (!(handler instanceof PortableFluidInterfaceTileEntity.InterfaceFluidHandler)) {
            return;
        }
        if (this.frontier.isEmpty()) {
            return;
        }
        ((PortableFluidInterfaceTileEntity.InterfaceFluidHandler)handler).keepAlive();
    }

    public void reset() {
        this.frontier.clear();
        this.visited.clear();
        this.targets.clear();
        this.queued.clear();
        this.fluid = FluidStack.EMPTY;
        this.queued.add(this.start);
        this.pauseBeforePropagation = 2;
    }

    @Nullable
    private PipeConnection get(BlockFace location) {
        BlockPos pos = location.getPos();
        FluidTransportBehaviour fluidTransfer = this.getFluidTransfer(pos);
        if (fluidTransfer == null) {
            return null;
        }
        return fluidTransfer.getConnection(location.getFace());
    }

    private boolean isPresent(BlockFace location) {
        return this.world.m_46749_(location.getPos());
    }

    @Nullable
    private FluidTransportBehaviour getFluidTransfer(BlockPos pos) {
        FluidTransportBehaviour behaviour;
        WeakReference<FluidTransportBehaviour> weakReference = this.cache.get(pos);
        FluidTransportBehaviour fluidTransportBehaviour = behaviour = weakReference != null ? (FluidTransportBehaviour)weakReference.get() : null;
        if (behaviour != null && behaviour.tileEntity.m_58901_()) {
            behaviour = null;
        }
        if (behaviour == null && (behaviour = TileEntityBehaviour.get((BlockGetter)this.world, pos, FluidTransportBehaviour.TYPE)) != null) {
            this.cache.put(pos, new WeakReference<FluidTransportBehaviour>(behaviour));
        }
        return behaviour;
    }
}

