/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HandCrankRenderer
extends KineticTileEntityRenderer {
    public HandCrankRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState state = te.m_58900_();
        Block block = state.m_60734_();
        PartialModel renderedHandle = null;
        if (block instanceof HandCrankBlock) {
            renderedHandle = ((HandCrankBlock)block).getRenderedHandle();
        }
        if (renderedHandle == null) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        SuperByteBuffer handle = CachedBufferer.partialFacing(renderedHandle, state, facing.m_122424_());
        HandCrankTileEntity crank = (HandCrankTileEntity)te;
        HandCrankRenderer.kineticRotationTransform(handle, te, facing.m_122434_(), (crank.independentAngle + partialTicks * crank.chasingVelocity) / 360.0f, light);
        handle.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

