/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.util;

import com.blakebr0.mysticalagriculture.tileentity.EssenceFurnaceTileEntity;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public enum FurnaceTier {
    INFERIUM("inferium", 0.84, 0.84, EssenceFurnaceTileEntity.Inferium::new),
    PRUDENTIUM("prudentium", 0.625, 0.84, EssenceFurnaceTileEntity.Prudentium::new),
    TERTIUM("tertium", 0.4, 0.68, EssenceFurnaceTileEntity.Tertium::new),
    IMPERIUM("imperium", 0.145, 0.5, EssenceFurnaceTileEntity.Imperium::new),
    SUPREMIUM("supremium", 0.025, 0.2, EssenceFurnaceTileEntity.Supremium::new);

    private final String name;
    private final double cookTimeMultiplier;
    private final double burnTimeMultiplier;
    private final BiFunction<BlockPos, BlockState, EssenceFurnaceTileEntity> tileEntityFunc;

    private FurnaceTier(String name, double cookTimeMultiplier, double burnTimeMultiplier, BiFunction<BlockPos, BlockState, EssenceFurnaceTileEntity> tileEntityFunc) {
        this.name = name;
        this.cookTimeMultiplier = cookTimeMultiplier;
        this.burnTimeMultiplier = burnTimeMultiplier;
        this.tileEntityFunc = tileEntityFunc;
    }

    public String getName() {
        return this.name;
    }

    public double getCookTimeMultiplier() {
        return this.cookTimeMultiplier;
    }

    public double getBurnTimeMultiplier() {
        return this.burnTimeMultiplier;
    }

    public EssenceFurnaceTileEntity createTileEntity(BlockPos pos, BlockState state) {
        return this.tileEntityFunc.apply(pos, state);
    }
}

