/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.registry;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropRecipes;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.PluginConfig;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.item.MysticalEssenceItem;
import com.blakebr0.mysticalagriculture.item.MysticalSeedsItem;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class CropRegistry
implements ICropRegistry {
    private static final CropRegistry INSTANCE = new CropRegistry();
    private Map<ResourceLocation, Crop> crops = new LinkedHashMap<ResourceLocation, Crop>();
    private Map<ResourceLocation, CropTier> tiers = new LinkedHashMap<ResourceLocation, CropTier>();
    private Map<ResourceLocation, CropType> types = new LinkedHashMap<ResourceLocation, CropType>();
    private boolean allowRegistration = false;
    private PluginConfig currentPluginConfig = null;

    @Override
    public void register(Crop crop) {
        if (this.allowRegistration) {
            if (this.crops.values().stream().noneMatch(c -> c.getName().equals(crop.getName()))) {
                this.crops.put(crop.getId(), crop);
                this.loadRecipeConfig(crop);
            } else {
                MysticalAgriculture.LOGGER.info("{} tried to register a duplicate crop with name {}, skipping", (Object)crop.getModId(), (Object)crop.getName());
            }
        } else {
            MysticalAgriculture.LOGGER.error("{} tried to register crop {} outside of onRegisterCrops, skipping", (Object)crop.getModId(), (Object)crop.getName());
        }
    }

    @Override
    public void registerTier(CropTier tier) {
        if (!this.tiers.containsKey(tier.getId())) {
            this.tiers.put(tier.getId(), tier);
        } else {
            MysticalAgriculture.LOGGER.info("{} tried to register a duplicate crop tier with id {}, skipping", (Object)tier.getModId(), (Object)tier.getId());
        }
    }

    @Override
    public void registerType(CropType type) {
        if (!this.types.containsKey(type.getId())) {
            this.types.put(type.getId(), type);
        } else {
            MysticalAgriculture.LOGGER.info("{} tried to register a duplicate crop type with id {}, skipping", (Object)type.getModId(), (Object)type.getId());
        }
    }

    @Override
    public List<Crop> getCrops() {
        return List.copyOf(this.crops.values());
    }

    @Override
    public Crop getCropById(ResourceLocation id) {
        return this.crops.get(id);
    }

    @Override
    public Crop getCropByName(String name) {
        return this.crops.values().stream().filter(c -> name.equals(c.getName())).findFirst().orElse(null);
    }

    @Override
    public List<CropTier> getTiers() {
        return List.copyOf(this.tiers.values());
    }

    @Override
    public CropTier getTierById(ResourceLocation id) {
        return this.tiers.get(id);
    }

    @Override
    public List<CropType> getTypes() {
        return List.copyOf(this.types.values());
    }

    @Override
    public CropType getTypeById(ResourceLocation id) {
        return this.types.get(id);
    }

    public static CropRegistry getInstance() {
        return INSTANCE;
    }

    public void setAllowRegistration(boolean allowed) {
        this.allowRegistration = allowed;
    }

    public void onRegisterBlocks(IForgeRegistry<Block> registry) {
        PluginRegistry.getInstance().forEach((plugin, config) -> {
            this.currentPluginConfig = config;
            plugin.onRegisterCrops(this);
        });
        Collection<Crop> crops = this.crops.values();
        crops.stream().filter(Crop::shouldRegisterCropBlock).forEach(c -> {
            CropBlock crop = c.getCropBlock();
            if (crop == null) {
                MysticalCropBlock defaultCrop = new MysticalCropBlock((Crop)c);
                crop = defaultCrop;
                c.setCropBlock(() -> defaultCrop, true);
            }
            if (crop.getRegistryName() == null) {
                crop.setRegistryName(c.getNameWithSuffix("crop"));
            }
            registry.register((IForgeRegistryEntry)crop);
        });
        this.crops = this.getSortedCropsMap(crops);
    }

    public void onRegisterItems(IForgeRegistry<Item> registry) {
        Collection<Crop> crops = this.crops.values();
        crops.stream().filter(Crop::shouldRegisterEssenceItem).forEach(c -> {
            Object essence = c.getEssenceItem();
            if (essence == null) {
                MysticalEssenceItem defaultEssence = new MysticalEssenceItem((Crop)c, p -> p.m_41491_(MysticalAgriculture.CREATIVE_TAB));
                essence = defaultEssence;
                c.setEssenceItem(() -> defaultEssence, true);
            }
            if (essence.getRegistryName() == null) {
                essence.setRegistryName(c.getNameWithSuffix("essence"));
            }
            registry.register((IForgeRegistryEntry)essence);
        });
        crops.stream().filter(Crop::shouldRegisterSeedsItem).forEach(c -> {
            ItemNameBlockItem seeds = c.getSeedsItem();
            if (seeds == null) {
                MysticalSeedsItem defaultSeeds = new MysticalSeedsItem((Crop)c, p -> p.m_41491_(MysticalAgriculture.CREATIVE_TAB));
                seeds = defaultSeeds;
                c.setSeedsItem(() -> defaultSeeds, true);
            }
            if (seeds.getRegistryName() == null) {
                seeds.setRegistryName(c.getNameWithSuffix("seeds"));
            }
            registry.register((IForgeRegistryEntry)seeds);
        });
        PluginRegistry.getInstance().forEach((plugin, config) -> plugin.onPostRegisterCrops(this));
        this.currentPluginConfig = null;
    }

    private void loadRecipeConfig(Crop crop) {
        CropRecipes recipes = crop.getRecipeConfig();
        PluginConfig config = this.currentPluginConfig;
        recipes.setSeedCraftingRecipeEnabled(recipes.isSeedCraftingRecipeEnabled() && config.isDynamicSeedCraftingRecipesEnabled());
        recipes.setSeedInfusionRecipeEnabled(recipes.isSeedInfusionRecipeEnabled() && config.isDynamicSeedInfusionRecipesEnabled());
        recipes.setSeedReprocessorRecipeEnabled(recipes.isSeedReprocessorRecipeEnabled() && config.isDynamicSeedReprocessorRecipesEnabled());
    }

    private Map<ResourceLocation, Crop> getSortedCropsMap(Collection<Crop> crops) {
        LinkedHashMap<ResourceLocation, Crop> sorted = new LinkedHashMap<ResourceLocation, Crop>();
        crops.stream().sorted(Comparator.comparingInt(c -> c.getTier().getValue())).forEach(c -> sorted.put(c.getId(), (Crop)c));
        return sorted;
    }
}

