/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class HoeIngredient
extends Ingredient {
    public static final List<HoeItem> ALL_HOES = new ArrayList<HoeItem>();
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public HoeIngredient() {
        super(Stream.of(new Ingredient.Value[0]));
    }

    public ItemStack[] m_43908_() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return this.stacks;
    }

    public IntList m_43931_() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(StackedContents.m_36496_((ItemStack)s)));
            this.stacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (ALL_HOES.size() == 0) {
            return stack.m_41619_();
        }
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41720_() != stack.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_43947_() {
        return !(!ALL_HOES.isEmpty() || this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement m_43942_() {
        JsonArray json = new JsonArray();
        ALL_HOES.stream().filter(h -> h.getRegistryName() != null).forEach(h -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", h.getRegistryName().toString());
            json.add((JsonElement)obj);
        });
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.HOE_INGREDIENT;
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])ALL_HOES.stream().map(ItemStack::new).toArray(ItemStack[]::new);
    }

    public static class Serializer
    implements IIngredientSerializer<HoeIngredient> {
        public HoeIngredient parse(FriendlyByteBuf buffer) {
            return new HoeIngredient();
        }

        public HoeIngredient parse(JsonObject json) {
            return new HoeIngredient();
        }

        public void write(FriendlyByteBuf buffer, HoeIngredient ingredient) {
        }
    }
}

