/*
 * Decompiled with CFR 0.152.
 */
package net.jirho.duckies.common.entity;

import java.util.Random;
import java.util.UUID;
import net.jirho.duckies.common.entity.DuckSwimGoal;
import net.jirho.duckies.core.init.EntityInit;
import net.jirho.duckies.core.init.ItemInit;
import net.jirho.duckies.core.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Duck
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Duck.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Boolean> DATA_SUFFOCATING = SynchedEntityData.m_135353_(Duck.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private UUID persistentAngerTarget;

    public Duck(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DuckSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.BREAD_CRUMBS.get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Duck)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 10.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.f_19853_, tag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public void setSuffocating(boolean bool) {
        this.f_19804_.m_135381_(DATA_SUFFOCATING, (Object)bool);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.BREAD_CRUMBS.get()}).test(stack);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : dimensions.f_20378_ * 0.92f;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)EntityInit.DUCK.get()).m_20615_((Level)level);
    }

    public void m_7023_(Vec3 vector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.2));
        } else {
            super.m_7023_(vector);
        }
    }

    public ResourceLocation m_7582_() {
        return new ResourceLocation("duckies", "entities/duck");
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int i) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)i);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID id) {
        this.persistentAngerTarget = id;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)SoundInit.DUCK_ATTACK.get();
        }
        return (SoundEvent)SoundInit.DUCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundInit.DUCK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.DUCK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public static boolean canSpawn(EntityType<Duck> entity, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Animal.m_27577_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

