/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequest {
    private BlockPos pos;
    private ItemStack stack;
    private int nbtHash;
    private int amount;

    public PacketRequest(BlockPos pos, ItemStack stack, int amount) {
        this.pos = pos;
        this.stack = stack;
        if (stack.m_41782_()) {
            this.nbtHash = stack.m_41783_().hashCode();
        }
        this.amount = amount;
    }

    private PacketRequest() {
    }

    public static PacketRequest fromBytes(FriendlyByteBuf buf) {
        PacketRequest packet = new PacketRequest();
        packet.pos = buf.m_130135_();
        packet.stack = buf.m_130267_();
        packet.nbtHash = buf.m_130242_();
        packet.amount = buf.m_130242_();
        return packet;
    }

    public static void toBytes(PacketRequest packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130055_(packet.stack);
        buf.m_130130_(packet.nbtHash);
        buf.m_130130_(packet.amount);
    }

    public static void onMessage(final PacketRequest message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.f_19853_, message.pos);
                message.stack.m_41764_(message.amount);
                tile.requestItem((Player)player, message.stack, message.nbtHash);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

