/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketNetworkItems {
    private List<ItemStack> items;
    private List<ItemStack> craftables;
    private List<ItemStack> currentlyCrafting;

    public PacketNetworkItems(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
    }

    private PacketNetworkItems() {
    }

    public static PacketNetworkItems fromBytes(FriendlyByteBuf buf) {
        int i;
        PacketNetworkItems client = new PacketNetworkItems();
        client.items = new ArrayList<ItemStack>();
        for (i = buf.m_130242_(); i > 0; --i) {
            ItemStack stack = buf.m_130267_();
            stack.m_41764_(buf.m_130242_());
            client.items.add(stack);
        }
        client.craftables = new ArrayList<ItemStack>();
        for (i = buf.m_130242_(); i > 0; --i) {
            client.craftables.add(buf.m_130267_());
        }
        client.currentlyCrafting = new ArrayList<ItemStack>();
        for (i = buf.m_130242_(); i > 0; --i) {
            client.currentlyCrafting.add(buf.m_130267_());
        }
        return client;
    }

    public static void toBytes(PacketNetworkItems packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.items.size());
        for (ItemStack stack : packet.items) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            buf.m_130055_(copy);
            buf.m_130130_(stack.m_41613_());
        }
        buf.m_130130_(packet.craftables.size());
        for (ItemStack stack : packet.craftables) {
            buf.m_130055_(stack);
        }
        buf.m_130130_(packet.currentlyCrafting.size());
        for (ItemStack stack : packet.currentlyCrafting) {
            buf.m_130055_(stack);
        }
    }

    public static void onMessage(final PacketNetworkItems message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                Screen screen = mc.f_91080_;
                if (screen instanceof ItemTerminalGui) {
                    ItemTerminalGui terminal = (ItemTerminalGui)screen;
                    terminal.updateItemList(message.items, message.craftables, message.currentlyCrafting);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

